.TH "ipcRemoteSende" TCL "" "TCL"
.ad b
.SH NAME
ipcRemoteSend - send a command to a remote TCL application.
.SH SYNOPSIS
.PP
.nf
.ft CW
#include <tclipc.h>

int
ipcRemoteSend(Sender sender,
              const char *fmt, ...);
.ft R
.fi
'
.SH DESCRIPTION
.PP
.SS ipcRemoteSend
.PP
This is the C routine used to send messages to remote TCL applications.  The function is a varargs routine much like printf.  The value returned is the result value returned by the remotely executed command.  The interpreter used is the one that created the sender with ipcNewSender or the "sender new" TCL command.
.PP
Parameters:
.RS 2
\fBo \fIsender\fR - This is a \fBtclIPC\fR sender structure as returned by 
ipcNewSender or the "sender new" user command.  
.br
.PP
\fBo \fIfmt\fR - This string describes the format of the following arguments.
The format is used to generate the command that will be sent to the receiver
specified by sender.
.br
.RE
.PP
Returns:
.RS 2
Returns TCL_ERROR or TCL_OK based on the result of the remote execution of the
command passed to the ipcRemoteSend command.  Error messages are returned in
the Sender's interpreter.
.RE
'

