/*
 * Collections:
 *
 * Simple circular linked lists of things, with an add operation, a foreach
 * operation, and a size operation.
 *
 * Kim Gillies
 * 28 December 1988
 * Created  28/12/88 KG
 * SCCS INFO
 * %W% %G%
 */

#ifndef collection_h
#define collection_h

#ifndef _TCL
#include "tcl.h"                 /* Get ANSI_ARGS--YECH */
#endif

#ifndef generic_ptr
typedef char *generic_ptr;
#endif

typedef struct cNode {
  generic_ptr info;
  struct cNode *next;
} *Collection;

#define CDATA(L) ((L)->info)
#define NEXT(L) ((L)->next)

#ifndef ERROR
typedef enum { NOERROR, ERROR } status;
#endif

/* CollectionEmpty- return true if the stack is empty. */
#define CollectionEmpty(head)        ((head)->next == NULL)

/* Return a new, empty collection */
status CollectionCreate _ANSI_ARGS_((Collection *c));

/* Destroy all opaque list memory */
void CollectionDestroy _ANSI_ARGS_((Collection c, void (*p_func_f)()));

/* Add the value info to the end of Collection c. */
status CollectionAppend _ANSI_ARGS_((Collection c, generic_ptr info));

/* Add info to list beginning */
status CollectionAdd _ANSI_ARGS_((Collection c, generic_ptr info));

/* Delete the value info to the Collection c */
status CollectionDelete _ANSI_ARGS_((Collection c, Collection node));

/* Delete the first member of c */
status CollectionDeleteFirst _ANSI_ARGS_((Collection c, generic_ptr *info));

/* Find a member and return it */
status CollectionFind _ANSI_ARGS_((Collection c, generic_ptr key,
				   int (*p_cmp_f)(), Collection *keynode));

/* Return the number of elements in the collection c */
int CollectionSize _ANSI_ARGS_((Collection c));

/* Return an arbitrary element of the Collection c. */
#define CollectionPickOne(c) (c->next ? c->next->info : NULL)

/* Iterate over the info in the elements of the collection c. 
 * At each iteration, theinfo
 * is set to the next value in the collection.  Usage:
 *      CollectionForEach(somecollection, info) {
 *        / * whatever you want to do with info * /
 *      } CollectionNext();
 */
#define CollectionForEach(c, theinfo) { \
  register Collection ccxx_p, ccxx_op; \
  if ((c) != NULL && (c)->next != NULL) { \
    ccxx_p = (c)->next; \
    while (1) { \
      ccxx_op = ccxx_p->next; \
      * (generic_ptr *)(&(theinfo)) = ccxx_p->info; {


/* Iterate over the elements of the collection c.  At each iteration, thenode
 * is set to the node entry in the collection.  Usage:
 *	CollectionForEach(somecollection, node) {
 *	  / * whatever you want to do with node * /
 *	} CollectionNext();
 */
#define CollectionForEachNode(c, thenode) { \
  register Collection ccxx_p, ccxx_op; \
  if ((c) != NULL && (c)->next != NULL) { \
    ccxx_p = (c)->next; \
    while (1) { \
      ccxx_op = ccxx_p->next; \
      * (Collection *)(&(thenode)) = ccxx_p; {

#define CollectionNext() } \
      if ((ccxx_p = ccxx_op) == NULL) break; \
    } \
  } \
}
#endif
