/*-
 * Copyright (c) 1993, 1994 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <assert.h>
#include <strstream.h>
#include "TclmInterp.h"

TclmInterp::TclmInterp() : current_song(0), next_event(0), device(0)
{

	Tcl_InitHashTable(&hash_table, TCL_STRING_KEYS);
}

TclmInterp::TclmInterp(const TclmInterp &ti)
{
	ostrstream *buf;
	Tcl_HashSearch search;
	Tcl_HashEntry *entry, *new_entry;
	Song *song, *new_song;
	char *key;
	int repeat;

	device = ti.device;
	current_song = 0;
	Tcl_InitHashTable(&hash_table, TCL_STRING_KEYS);
	entry = Tcl_FirstHashEntry((Tcl_HashTable *)&ti.hash_table, &search);
	while (entry != 0) {
		song = (Song *)Tcl_GetHashValue(entry);

		// make a new entry
		buf = new ostrstream;
		*buf << "song" << current_song << ends;
		key = buf->str();
		new_entry = Tcl_CreateHashEntry(&hash_table, key, &repeat);
		new_song = new Song(*song);
		assert(new_song != 0);
		Tcl_SetHashValue(new_entry, new_song);
		delete key;
		delete buf;
		current_song++;

		// find next entry
		entry = Tcl_NextHashEntry(&search);
	}
}

TclmInterp::~TclmInterp()
{
	Tcl_HashSearch search;
	Tcl_HashEntry *entry;
	Song *song;

	// delete existing entries
	entry = Tcl_FirstHashEntry(&hash_table, &search);
	while (entry != 0) {
		song = (Song *)Tcl_GetHashValue(entry);
		delete song;
		Tcl_DeleteHashEntry(entry);
		entry = Tcl_NextHashEntry(&search);
	}

	// delete table
	Tcl_DeleteHashTable(&hash_table);

}

Song *
TclmInterp::GetSong(const char *key) const
{
	Tcl_HashEntry *entry;

	entry = Tcl_FindHashEntry((Tcl_HashTable *)&hash_table, (char *)key);
	if (entry == 0)
		return (0);
	return ((Song *)Tcl_GetHashValue(entry));
}

char *
TclmInterp::AddSong(const Song *song)
{
	ostrstream buf;
	char *key;
	Tcl_HashEntry *entry;
	int repeat;

	buf << "song" << current_song++ << ends;
	key = buf.str();
	entry = Tcl_CreateHashEntry(&hash_table, key, &repeat);
	Tcl_SetHashValue(entry, song);
	return (key);
}

int
TclmInterp::DeleteSong(const char *key)
{
	Tcl_HashEntry *entry;
	Song *song;

	entry = Tcl_FindHashEntry(&hash_table, (char *)key);
	if (entry == 0)
		return (0);
	song = (Song *)Tcl_GetHashValue(entry);
	delete song;
	Tcl_DeleteHashEntry(entry);
	return (1);
}

void
TclmInterp::SetMidiDevice(MidiDevice *dev)
{

	device = dev;
}

MidiDevice *
TclmInterp::GetMidiDevice(void) const
{

	return (device);
}

TclmInterp &
TclmInterp::operator=(const TclmInterp &ti)
{
	ostrstream *buf;
	Tcl_HashSearch search;
	Tcl_HashEntry *entry, *new_entry;
	Song *song, *new_song;
	char *key;
	int repeat;

	// delete existing entries
	entry = Tcl_FirstHashEntry(&hash_table, &search);
	while (entry != 0) {
		song = (Song *)Tcl_GetHashValue(entry);
		delete song;
		Tcl_DeleteHashEntry(entry);
		entry = Tcl_NextHashEntry(&search);
	}

	current_song = 0;
	entry = Tcl_FirstHashEntry((Tcl_HashTable *)&ti.hash_table, &search);
	while (entry != 0) {
		song = (Song *)Tcl_GetHashValue(entry);

		// make a new entry
		buf = new ostrstream;
		*buf << "song" << current_song << ends;
		key = buf->str();
		new_entry = Tcl_CreateHashEntry(&hash_table, key, &repeat);
		new_song = new Song(*song);
		assert(new_song != 0);
		Tcl_SetHashValue(new_entry, new_song);
		delete key;
		delete buf;
		current_song++;

		// find next entry
		entry = Tcl_NextHashEntry(&search);
	}

	device = ti.device;
	return (*this);
}
