/*-
 * Copyright (c) 1993, 1994 Michael B. Durian.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Michael B. Durian.
 * 4. The name of the the Author may be used to endorse or promote 
 *    products derived from this software without specific prior written 
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef MPU401COPY_H
#define MPU401COPY_H

#include "MidiDevice.h"

const int MaxEventSize = 256;

class MPU401Copy : public MidiDevice {
	friend ostream &operator<<(ostream &os, const MPU401Copy &mpu);
	friend void MPU401CopySigIO(int notused);
public:
	MPU401Copy();
	MPU401Copy(const char *dev);
	virtual ~MPU401Copy();

	virtual int Play(Song *s, int r = 0);
	virtual int Record(Song *rec_song, Song *play_song = 0, int r = 0);
	virtual int Stop(void);
	virtual int Wait(void);
private:
	int Send(void);
	int BuildSMF(SMFTrack &smftrack, Song *s);

	unsigned long last_rec_time;
	SMFTrack play_track;
	Song *rec_song;
	const unsigned char *playbuf, *playbufptr, *playbufend;
	int fd;
	volatile int finished, should_stop;
	unsigned char last_record_rs;
};
#endif
