#---------------------------------------------------------------------------
#
#	Create Title Label
#
#---------------------------------------------------------------------------

defwidget Label

defmethod Label new {name args} {

  args	relief text {width 15} fit {textfont bold} edittext layout \
	{anchor w} action

  if { $textfont == {} } {
    set textfont bold
  }
  if { $fit == "true" } {
    set width 0
  }
  if { $relief == {} } {
    set relief raised
  }

  if { $edittext != "true" } {
    label $name \
	-font [Font slot $textfont] -relief ${relief} \
	-borderwidth 2 -text "${text}" \
	-width $width -anchor $anchor \
	-background [Color slot bg] \
	-foreground [Color slot fg]

    Label instantiate $name $layout
  } {
    Textlabel new $name -relief $relief -text $text -width $width \
	-textfont $textfont -layout $layout
  }
}

defmethod Flatlabel new {name args} {

  eval [concat [list Label new $name] $args [list -relief flat]]
}

#	Create a label for use at the top of listboxes or canvases. The label
#	is not created if "text" is empty.
#
defmethod Label newnonempty {name args} {

  args	text {textfont bold}

  if { $text != {} } {
    Label new $name -layout {top frame center} -anchor e \
	-relief flat -text $text -textfont $textfont -fit true
    return $name
  }
  return
}

defmethod Label get {} {
  lindex [$self! configure -text] 4
}

defmethod Label set {text} {
  $self! configure -text $text
  return
}

#---------------------------------------------------------------------------

defwidget Textlabel {Text Label}

defmethod Textlabel new {name args} {

  args	relief text {width 15} {textfont bold} layout

  if { $textfont == {} } {
    set textfont bold
  }
  if { $relief == {} } {
    set relief sunken
  }

  Text new $name -state disabled -text text -textfont $textfont \
	-relief $relief -width $width -height 3 -layout $layout
  defsuper $name Textlabel

  return $name
}

#---------------------------------------------------------------------------

defwidget Bitmap

defmethod Bitmap new {name args} {

  args	relief {width 15} bitmap layout {anchor c} fit

  if { $fit == "true" } {
    set width 0
  }
  if { $relief == {} } {
    set relief flat
  }

  label ${name} -relief $relief -anchor $anchor \
	-borderwidth 0 -bitmap ${bitmap} \
	-background [Color slot bg] \
	-foreground [Color slot fg]

  Bitmap instantiate $name $layout
}

#---------------------------------------------------------------------------

defwidget Title Label

# new(title) {name -text}
#	Create a new title label for a toplevel window.
#
defmethod Title new {name args} {

  args	text

  label $name -relief raised -borderwidth 3 -padx 20 -pady 15 \
	-text $text -font [Font slot largebold] \
	-background [Color slot bg] \
	-foreground [Color slot fg]

  Title instantiate $name {top padx 20 pady 30 frame center}
}

#---------------------------------------------------------------------------

defwidget Space

# proc new(space) {name -width -layout}
#	Make an empty label of given width (default: 1).
#
defmethod Space new {name args} {

  args	{width 1} layout

  label $name -width $width -text "" -relief flat \
	-background [Color slot bg]

  Space instantiate $name $layout
}

#---------------------------------------------------------------------------

defwidget Infoline Label

# proc new(infoline) {name}
#	Create a new info line at the bottom of "name"'s parent.
#
defmethod Infoline new {name args} {
  global system

  args	

  set dpi [winfo pixels . 1i]
  set size "[winfo screenwidth .]x[winfo screenheight .]x[winfo screendepth .]"
  set who "[env fullname]@[exec hostname]"

  label $name \
	-font [Font slot smallbold] -relief flat \
	-borderwidth 2 -anchor w \
	-background [Color slot bg] \
	-foreground [Color slot fg] \
	-text "This is $who on [winfo screen .] ($size ${dpi}dpi)."

  Infoline instantiate $name {bottom fillx}
}

#---------------------------------------------------------------------------

defwidget Pair Label

defmethod Pair new {name args} {
  global info

  args label text {labelfont bold} {textfont text} layout fit edittext

  Frame new ${name} -layout $layout -relief flat
  defsuper $name Pair

  Label new ${name}.a -layout {left frame nw padx 5} -relief flat \
	-text $label -width 15 -textfont $labelfont -fit $fit
  Label new ${name}.v -layout {left frame nw padx 5} -relief sunken \
	-text $text -width 32 -textfont $textfont -edittext $edittext

  return $name
}

defmethod Pair get {} {
  $self.v get
}

defmethod Pair set {text} {
  $self.v set $text
}

#---------------------------------------------------------------------------

defwidget Corner

defmethod Corner new {name args} {

  args	layout

  frame $name -width 19 -height 19 -relief flat \
	-borderwidth 0 -background [Color slot bg]
  Corner instantiate $name $layout

  return $name
}
