
defmethod _Filter chooseNumberX {old new} {

  $self clear
  $self chooseNumber $old $new
}

defmethod _Filter chooseNonNull {old new} {

  if { $new != {} } {
    return $new
  }
  return $old
}

defmethod _Filter chooseNumber {old new} {

  if { [regexp {^[0-9]+$} $new] == 1 } {
    return $new
  }
  return $old
}

defmethod _Filter chooseNumberOrNull {old new} {

  if { $new == "" } {
    return ""
  }
  if { [regexp {^[0-9]+$} $new] == 1 } {
    return $new
  }
  return $old
}

defmethod _Filter chooseDottedNumber {old new} {

  if { [regexp {^[0-9.]+$} $new] == 1 } {
    return $new
  }
  return $old
}

defmethod _Filter chooseString {old new} {

  if { [regexp {^[a-zA-Z][a-zA-Z0-9.+, -]*$} $new] == 1 } {
    return $new
  }
  return $old
}

defmethod _Filter allowNumber {key} {

  if { $key == "\r" } {
    return "\n"
  }
  if { $key >= "0" && $key <= "9" } {
    return $key
  }
  return
}
