## bookmarks.tcl tkW3 bookmarks facility
## ==============
## Copyright (C) 1992-1993
## Global Network Academy
## Macvicar Institute for Educational Software Development
##
## See the file COPYRIGHT for conditions

## This file contains code to implement the bookmarks feature of tkW3
## Note that the file which tkW3 uses to load and save bookmarks is a
## valid HTML file.  That is to say, you can save some bookmarks into a
## file and then view that file using tkW3.

## Some of the procedures in this file refer directly to tkW3 widgets.
## (i.e. they add or remove entries from a menu and refer directly to that
## menu).  That's probably bad abstraction.

## The bookmarks facility is quite rudimentary

## Conventions:
##   all global visible objects in this file should begin with 
##   tkW3Bookmarks

## Global Variables

# tkW3BookmarksList contains bookmarks in 
# {{title address} {title address}} format
set tkW3BookmarksList {}

proc tkW3BookmarksInitialize {} {
}

# tkW3BookmarksDefaultFile is the default file which the bookmarks are
# saved in
set tkW3BookmarksDefaultDirectory $env(HOME)
set tkW3BookmarksDefaultFile "bookmarks.html" 

## tkW3BookmarksAdd: Add a bookmark
## -----------
## Arguments
##   title - Title of the bookmark
##   address - Address bookmark refers to
##
## If called with no arguments it sets title and address to current values
## No return value
## 
## This procedure adds a bookmark to the list of bookmarks
##

proc tkW3BookmarksAdd {{title ""} {address ""}} {
    global tkW3BookmarksList
    if {$title == "" && $address == ""} {
	set address [tkW3NavigateGetAddress]
	set title [tkW3NavigateGetTitle]
    }
    lappend tkW3BookmarksList [list $title $address]
    tkW3MenuMakeNodeMenu .menu.bookmarks.m.bookmarks $tkW3BookmarksList
    tkW3ConfigDisplay
}

## tkW3BookmarksClear: clear all bookmarks
## -----------
## No arguments
## No return value
##
## This procedure clears all of the bookmarks 
##

proc tkW3BookmarksClear {} {
    global tkW3BookmarksList
    set tkW3BookmarksList {}
}

proc tkW3BookmarksDelete {} {
    tkW3HelpNotAvailable
}

## tkW3BookmarksLoadDialog: Brings up file dialog to load bookmarks
## -----------
## Arguments:
##   clearentries - determines if previous bookmarks should be removed
## No return value
##
## This procedure pops up a file dialog by which the user can choose a 
## file to load bookmarks from.  If clearentries is non-zero, tkW3
## will forget about the old bookmarks, when it loads the new ones

proc tkW3BookmarksLoadDialog {clearentries} {
    global fsBox env
    # $clearentries is expanded when this procedure is called
    # xfFSPath and xfFSName are not
   
    if [info exists env(HOME)] {
	set fsBox(path) $env(HOME)
    }

    FSBox {Load Bookmarks} "bookmarks.html" \
	"tkW3BookmarksLoad \$fsBox(path)/\$fsBox(name) $clearentries"
    DLG:show . .fsBox
}

proc tkW3BookmarksSaveDialog {} {
    global fsBox env
    if [info exists env(HOME)] {
	set fsBox(path) $env(HOME)
    }

    FSBox {Save Bookmarks} "bookmarks.html" \
         {tkW3BookmarksSave $fsBox(path)/$fsBox(name)}
    DLG:show . .fsBox
}

# Load bookmarks from file
# Clear entries if clearentries is true

proc tkW3BookmarksLoad {filename clearentries} {
    global tkW3BookmarksList
    set file {}

# open the file
# trap for errors
    if {[catch {open $filename r} file]} {
	tkW3OutputError $file
	return
    }

# clear the bookmarks
    if {$clearentries} {
	tkW3BookmarksClear
    }

# while there is stuff in the file
    while {[gets $file string] != -1} { 
# the line contains a hypertext anchor load it
	if {[regexp {HREF="(.*)">(.*)</A>} $string {} address title]} {
	    lappend tkW3BookmarksList [list $title $address]
	}
    }
    close $file
    .menu.bookmarks.m entryconfigure 0 -state normal
    tkW3MenuMakeNodeMenu .menu.bookmarks.m.bookmarks $tkW3BookmarksList
}

# save bookmarks in "filename"
proc tkW3BookmarksSave {filename} {
    global tkW3BookmarksList

    if {[catch {open $filename w} file]} {
	tkW3OutputError $file
	return
    }

    puts $file "<TITLE>tkWWW Bookmarks File</TITLE>"
    puts $file "<UL>"

    set i 0
    foreach item $tkW3BookmarksList {
	puts $file \
	    "<LI><A HREF=\"[lindex $item 1]\">[lindex $item 0]</A>"
        incr i
    }
    puts $file "</UL>"
    close $file
}
