/**/## main.tcl main file for tkWWW  user interface
/**/## ==============
/**/## Copyright (C) 1992-1993
/**/## Global Network Academy
/**/## Macvicar Institute for Educational Software Development
/**/##
/**/## See the file COPYRIGHT for conditions 

/**/## *************************
/**/## This is the main file for tkWWW
/**/## Do not edit main.tcl.  Instead edit main.cpp and run make.
/**/## *************************

/**/## *************************
/**/## This is the directory containing the source code
/**/## *************************

set tkW3SourcePath CPP_TK_WWW_SOURCE_PATH

/**/## *************************
/**/## end of user defined parameters
/**/## *************************

source $tkW3SourcePath/config.tcl

set tkW3Version "0.9"

/**/# Forbid rename for security sake
rename rename ""

/**/# Add the source path to the auto load table
set auto_path "$tkW3SourcePath $auto_path"

/**/## *************************
/**/## Parse the command line
/**/## *************************

tkW3ParseArgs $argv

/**/## *************************
/**/## Startup the server
/**/## Do this early do that the server has time to "warm up" 
/**/## before we actually use it
/**/## *************************

tkW3NavigateStartupServer

/**/# ************************
/**/# Check for incompatibilties between frontend and backend
/**/# ************************

tkW3VersionVerify $tkW3Version

/**/# *************************
/**/# Window management and Interface code 
/**/# *************************
wm title . "tkWWW"
wm minsize . 0 0
wm iconbitmap . @$tkW3SourcePath/bitmap/logo


pack append . \
    [ tkW3MenuMakeMenus .menu $tkW3ConfigMenus ] {top fillx} \
    [ tkW3OutputMakeTitleBox .titles ] {top fillx} \
    [ tkW3OutputMakeText .f ] {top expand fill } \
    [ tkW3OutputMakeButtons .buttons $tkW3ConfigButtons ] {top fillx} \
    [ tkW3OutputMakeEntries .style $tkW3ConfigEntries ] {top fillx } \
    [ tkW3OutputMakeToggles .toggles $tkW3ConfigToggles ] {top fillx} 

tkW3OutputMakeScrollbars


/**/## *************************
/**/## source user configuration file
/**/## *************************

catch {source "$env(HOME)/.tkWWW-config"}


/**/## *************************
/**/## Do initializations
/**/## *************************

tkW3NavigateInitialize
tkW3FontInitialize
tkW3FileInitialize
tkW3EditInitialize
tkW3HistoryInitialize
tkW3PanInitialize
tkW3HelpInitialize
tkW3BookmarksInitialize
FSBoxInitialize

/**/## *************************
/**/## GUI is created
/**/## Set the welcome message and
/**/## Jump to the first page
/**/## *************************

if {$tkW3ParseArgsShowInfo != 0} {
	tkW3HelpAbout
}
tkW3NavigateGoto $tkW3ConfigStartPage

/**/## enable image links
if {$tkW3ParseArgsImages(anchor) != ""} {
    tkW3ImageEnableAnchor \
	$tkW3ParseArgsImages(anchor) $tkW3ParseArgsImages(ismap)
}
