 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File:	init.tcl

# Description:
#	Initialization file for the Tk parametric framework.
#
#	This file is the initialization procedure for the Tk parametric
#	framework library.  It is invoked by
#
#c		source $dirName/init.tcl
#
#	where dirName is the directory in which the library resides.
#
#	It takes the following actions.
#
#	- The directory is added at the start of $auto_path.
#	  (The name is obtained using `info script'.)
#
#	- The `tkerror' function is loaded, causing Tk errors to be
#	  handled in the parametric framework library, and overriding
#	  any previous background error handler.
#
#	- Bindings are established for all widget classes to support keyboard
#	  traversal and focusable buttons.
#
#	- <FocusIn> and <FocusOut> handlers are established for the
#	  Toplevel window class, to implement the mixed focus model wherein
#	  toplevel widgets are focus-follows-mouse but other widgets are
#	  explicit-focus.
#	  
#	- A binding for the <Destroy> event is established for all widgets,
#	  in order to allow a hierarchy of widget destructors.  See
#	  `widget:destroy' for a description of this procedure.


 # $Id: init.tcl,v 1.14 1993/11/01 18:20:46 kennykb Exp $
 # $Source: /homedisk/julius/u0/kennykb/src/tkauxlib_ship/RCS/init.tcl,v $
 # $Log: init.tcl,v $
 # Revision 1.14  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.13  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.12  1993/10/26  21:40:14  kennykb
 # Added an `all' binding for the <Unmap> event, so as to be able to manage
 # refocus after the focus widget is unmapped.
 #
 # Revision 1.11  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.10  1993/10/20  18:46:26  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.9  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.8  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.7  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.6  1993/10/14  13:38:26  kennykb
 # Add binding to catch application destruction and zap those who are
 # waiting on variables.
 #
 # Revision 1.5  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.4  1993/07/20  19:17:12  kennykb
 # Improved structured comments.
 # Changed modules through `g' in the alphabet to follow `:' and `_' naming
 # conventions.
 #
 # Revision 1.3  1993/07/19  18:49:24  kennykb
 # Renamed all button_ commands to either button. or button:, in
 # conformance with new module naming conventions.
 #
 # Revision 1.2  1993/07/16  15:58:00  kennykb
 # Renamed all commands that start with `wiget.' to either `widget_' or
 # `widget:'.  Added the code for creating composite widgets.
 #
 # Revision 1.1  1993/06/03  15:29:46  kennykb
 # Initial revision
 #

 # Put us on the auto_path, and load up the tkerror procedure

set tkaux_library [file dirname [info script]]
set auto_path [linsert $auto_path 0 $tkaux_library]
source $tkaux_library/tkerror.tcl

	# BINDINGS:

	# Buttons

button_bindForTraversal Button

	# Canvases must be handled item-by-item, according to what the items do
	# with the keyboard focus.

	# Checkbuttons.

button_bindForTraversal Checkbutton

	# Entries.

entry_bindForTraversal Entry

	# Listboxes don't normally accept focus.  This should be changed.

	# Menus and Menubuttons are done reasonably competently by Tk

	# Radiobuttons

button_bindForTraversal Radiobutton

	# Scales

scale_bindForTraversal Scale

	# Scrollbars don't need keyboard traversal, particularly if
	# keyboard operations such as <PageUp> and <PageDown> are
	# made to work in listboxes

	# Texts

bind Text <1> {text.press %W %x %y}
focus_bindForTraversal Text -controlonly

	# Turn on the focus management for toplevel windows

bind Toplevel <FocusIn> { toplevel_focusIn %W %d }
bind . <FocusIn> { toplevel_focusIn %W %d }

	# Manage widget destruction for cleanup

bind all <Destroy> { widget:destroy %W }
bind all <Unmap> { widget:unmap %W }
widget_addBinding . Destroy { widget:destroyApp }
