/* Copyright 93 GROUPE BULL -- See license conditions in file COPYRIGHT */
/* 
 * tclttMessage.c
 *
 *	tt_message_* functions
 *
 * $Id: tclttMessage.c,v 1.8 93/08/13 15:31:57 beust Exp Locker: beust $
 */

#include <string.h>     /* for strdup() */
#include "main.h"

int
Tcltt_message_address_set(ClientData data, Tcl_Interp *interp,
			int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_address_set((Tt_message) atol(argv[1]),
				  (Tt_address) atol(argv[2]));
return result;
}

int
Tcltt_message_class_set(ClientData data, Tcl_Interp *interp,
			int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_class_set((Tt_message) atol(argv[1]),
				(Tt_address) atol(argv[2]));
  return result;
}

int
Tcltt_message_create(ClientData data, Tcl_Interp *interp,
		     int argc, char **argv)
{
  int result = 0;
  ARG(0);
  sprintf(Tcltt_Result, "%u", tt_message_create());
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_op(ClientData data, Tcl_Interp *interp,
		     int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_message_op((Tt_message) atol(argv[1]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_message_op_set(ClientData data, Tcl_Interp *interp,
		     int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_op_set((Tt_message) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_message_scope_set(ClientData data, Tcl_Interp *interp,
			int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_scope_set((Tt_message) atol(argv[1]),
				(Tt_scope) atol(argv[2]));
  return result;
}

int
Tcltt_message_arg_val(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  interp -> result =  tt_message_arg_val((Tt_message) atol(argv[1]),
					 (int) atol(argv[2]));
  return result;
}

int
Tcltt_message_arg_val_set(ClientData data, Tcl_Interp *interp,
			  int argc, char **argv)
{
  int result = 0;
  ARG(3);
  result =  tt_message_arg_val_set((Tt_message) atol(argv[1]),
				   atol(argv[2]),
				   argv[3]);
  return result;
}

int
Tcltt_message_arg_add(ClientData data, Tcl_Interp *interp,
			  int argc, char **argv)
{
  int result = 0;
  ARG(4);
  result = tt_message_arg_add((Tt_message) atol(argv[1]),
			      (Tt_mode) atol(argv[2]),
			      argv[3],
			      argv[4]);
  return result;
}

int
Tcltt_message_callback_add(ClientData data, Tcl_Interp *interp,
			   int argc, char **argv)
{
  int result = 0;
  Tt_message_callback f;

  ARG(2);
#ifdef TCL7
  Tcl_CmdInfo info;

  if (result = Tcl_GetCommandInfo(interp, argv[2], & info) == 0) {
    fprintf(stderr, "*** tcltt: '%s' no such callback\n", argv[2]);
  }
  else {
    TclTT_property_add((void *) atoi(argv[1]), argv[2]);
    result = tt_message_callback_add((Tt_message) atol(argv[1]),
				     TclTT_generic_pattern_callback);
    /*
				     (Tt_message_callback) info.proc);
   */
  }
#else
  TclTT_property_add((void *) atoi(argv[1]), argv[2]);
  result = tt_message_callback_add((Tt_message) atol(argv[1]),
				   TclTT_generic_pattern_callback);
#endif
  return result;
}

int
Tcltt_message_send(ClientData data, Tcl_Interp *interp,
		   int argc, char **argv)
{
  int result = 0;
  ARG(1);
  result = tt_message_send((Tt_message) atol(argv[1]));
  return result;

}

int
Tcltt_message_reply(ClientData data, Tcl_Interp *interp,
		    int argc, char **argv)
{
  int result = 0;
  ARG(1);
  result = tt_message_reply((Tt_message) atol(argv[1]));
  return result;

}

int
Tcltt_message_receive(ClientData data,Tcl_Interp *interp, int argc,char **argv)
{
  int result = 0;
  ARG(0);
  sprintf(Tcltt_Result, "%u", tt_message_receive());
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_create_super(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u",
	  tt_message_create_super((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_destroy(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  result = tt_message_destroy((Tt_message)atol(argv[1]));
  return result;
}

int
Tcltt_message_reject(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  result = tt_message_reject((Tt_message) atol(argv[1]));
  return result;
}

int
Tcltt_message_fail(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  result = tt_message_fail((Tt_message) atol(argv[1]));
  return result;
}

int
Tcltt_message_pattern(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_message_pattern((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_user(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  sprintf(Tcltt_Result, "%u", tt_message_user((Tt_message) atol(argv[1]),
					      atol(argv[2])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_user_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(3);
  result = tt_message_user_set((Tt_message) atol(argv[1]),
			       atol(argv[2]),
			       (void *) atol(argv[3]));
  return result;
}

int
Tcltt_message_arg_mode(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  tt_message_arg_mode((Tt_message) atol(argv[1]), (int) atol(argv[2]));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_arg_type(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  interp -> result = tt_message_arg_type((Tt_message) atol(argv[1]),
					 (int) atol(argv[2]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_message_args_count(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u",
	  tt_message_args_count((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_class(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_message_class((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_file(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_message_file((Tt_message) atol(argv[1]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_message_file_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_file_set((Tt_message) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_message_object(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_message_object((Tt_message) atol(argv[1]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_message_object_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_object_set((Tt_message) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_message_opnum(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_message_opnum((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_otype(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_message_otype((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_otype_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_otype_set((Tt_message) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_message_address(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_message_address((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_handler(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_message_handler((Tt_message) atol(argv[1]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_message_handler_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_handler_set((Tt_message) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_message_handler_ptype(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_message_handler_ptype((Tt_message) atol(argv[1]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_message_handler_ptype_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_handler_ptype_set((Tt_message) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_message_disposition(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u",
	  tt_message_disposition((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_disposition_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_disposition_set((Tt_message) atol(argv[1]),
				      (Tt_disposition) atol(argv[2]));
  return result;
}

int
Tcltt_message_scope(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u",
	  tt_message_scope((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_sender(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_message_sender((Tt_message) atol(argv[1]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_message_sender_ptype(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_message_sender_ptype((Tt_message) atol(argv[1]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_message_sender_ptype_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_sender_ptype_set((Tt_message) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_message_session(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_message_session((Tt_message) atol(argv[1]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_message_session_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_session_set((Tt_message) atol(argv[1]), argv[2]);
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_state(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_message_state((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_status(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_message_status((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_status_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result = tt_message_status_set((Tt_message) atol(argv[1]), atol(argv[2]));
  return result;
}

int
Tcltt_message_status_string(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  interp -> result = tt_message_status_string((Tt_message) atol(argv[1]));
  if (! interp -> result) interp -> result = "";
  return result;
}

int
Tcltt_message_status_string_set(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(2);
  result =
    tt_message_status_string_set((Tt_message) atol(argv[1]), argv[2]);
  return result;
}

int
Tcltt_message_uid(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_message_uid((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

int
Tcltt_message_gid(ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
  int result = 0;
  ARG(1);
  sprintf(Tcltt_Result, "%u", tt_message_gid((Tt_message) atol(argv[1])));
  interp -> result = Tcltt_Result;
  return result;
}

