#==============================================================================
#                               structure.tcl
#------------------------------------------------------------------------------
# A port of SIPP demo program structure.c to Tcl-SIPP.
#------------------------------------------------------------------------------
# $Id: structure.tcl,v 5.0 1994/09/05 01:21:47 markd Rel $
#------------------------------------------------------------------------------

if {[info commands DoRendering] == ""} {
    if [file exists ./demoutil.tlib] {
        loadlibindex ./demoutil.tlib
    } else {
        set demoutil [searchpath $auto_path demos/demoutil.tlib]
        if [lempty $demoutil] {
            error "Can't find \"demos/demoutil.tlib\" on auto_path"
        }
        loadlibindex $demoutil
    }
}
ParseDemoArgs

set SPHERERES 40
set CYLRES    40
set M_PI      3.14159265358979323846

proc SIGNBIT {bit i} {return [expr {(($i >> $bit) & 1) ? -1.0 : 1.0}]}

set surf [SippShaderBasic 0.4 0.7 0.1 {0.8 0.6 0.3}]
    
set bumpy_surf [SippShaderBumpy $surf 14.0 HOLES]

SippLightSourceCreate { 1.0  1.0 1.0} {0.9 0.9 0.9} DIRECTION
SippLightSourceCreate {-1.0 -1.0 0.5} {0.4 0.4 0.4} DIRECTION

set cyl_surf [SippShaderBasic 0.5 0.4 0.3 {0.5 0.6 0.8}]
    
set structure [SippObjectCreate]

set sphere [SippSphere 1.0 $SPHERERES $bumpy_surf WORLD]

for {set i 0} {$i < 8} {incr i} {
    if $i {
        set sphere [SippObjectInstance $sphere]
    }
    SippObjectMove $sphere [list [expr 2.0 * [SIGNBIT 2 $i]] \
                                 [expr 2.0 * [SIGNBIT 1 $i]] \
                                 [expr 2.0 * [SIGNBIT 0 $i]]]
    SippObjectAddSubobj $structure $sphere
}

set cyl [SippCylinder 0.25 4.0 $CYLRES $cyl_surf WORLD]

for {set i 0} {$i < 4} {incr i} {
    if $i {
        set cyl [SippObjectInstance $cyl]
    }
    SippObjectMove $cyl [list [expr 2.0 * [SIGNBIT 1 $i]] \
                              [expr 2.0 * [SIGNBIT 0 $i]] 0.0]
    SippObjectAddSubobj $structure $cyl
}

for {set i 0} {$i < 4} {incr i} {
    set cyl [SippObjectInstance $cyl]
    SippObjectRotateX $cyl [expr $M_PI / 2.0]
    SippObjectMove $cyl [list [expr 2.0 * [SIGNBIT 1 $i]] 0.0 \
                              [expr 2.0 * [SIGNBIT 0 $i]]]
    SippObjectAddSubobj $structure $cyl
}

for {set i 0} {$i < 4} {incr i} {
    set cyl [SippObjectInstance $cyl]
    SippObjectRotateY $cyl [expr $M_PI / 2.0]
    SippObjectMove $cyl [list 0.0 [expr 2.0 * [SIGNBIT 1 $i]] \
                                  [expr 2.0 * [SIGNBIT 0 $i]]]
    SippObjectAddSubobj $structure $cyl
}

SippObjectAddSubobj WORLD $structure

SippCameraParams STDCAMERA {10.0 -5.0 15.0} {0.0 0.0 0.0} {0.0 0.0 1.0} 0.25

DoRendering "structure"
