/* 
 * tclSippAppInit.c --
 *
 *  TSIPP initialization and main.
 *
 *-----------------------------------------------------------------------------
 * Copyright 1992-1995 Mark Diekhans
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Mark Diekhans makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *-----------------------------------------------------------------------------
 * $Id: tSippAppInit.c,v 5.8 1996/10/26 19:00:07 markd Exp $
 *-----------------------------------------------------------------------------
 */

#include "tSippInt.h"

/*
 * The following variable is a special hack that insures the tcl
 * version of matherr() is used when linking against shared libraries
 */
EXTERN int matherr _ANSI_ARGS_((struct exception *));
int *tclDummyMathPtr = (int *) matherr;


/*=============================================================================
 * Tcl_AppInit --
 *
 *   Tcl SIPP aplication initialization. 
 *-----------------------------------------------------------------------------
 */
int
Tcl_AppInit (interp)
    Tcl_Interp *interp;
{
    if (Tcl_Init (interp) == TCL_ERROR)
        return TCL_ERROR;

    if (Tclx_Init (interp) == TCL_ERROR)
        return TCL_ERROR;
    Tcl_StaticPackage (interp, "Tclx", Tclx_Init, Tclx_SafeInit);

    /*
     * Initialize SIPP and the TSIPP commands.
     */
    if (Tsipp_Init (interp) == TCL_ERROR)
        return TCL_ERROR;

    /*
     * Specify a startup file.
     */
    Tcl_SetVar(interp, "tcl_rcFileName", "~/.tsipprc", TCL_GLOBAL_ONLY);
    return TCL_OK;
}

/*=============================================================================
 * main --
 *
 *   Main program entry point.
 *
 *-----------------------------------------------------------------------------
 */
int
main (argc, argv)
    int    argc;
    char **argv;
{
    TclX_Main (argc, argv, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}
