# UserMaint V1.0 by Charles A. Eads
#
# Copyright (c) 1993 The Regents of the University of California.
# All rights reserved.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written agreement is
# hereby granted, provided that the above copyright notice and the following
# two paragraphs appear in all copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

proc userlist_create { w } \
{
	global USER_LIST_FONT
	global BACKGROUND_COLOR_MAIN
	frame $w.userlist -borderwidth 5 -background $BACKGROUND_COLOR_MAIN
	scrollbar $w.userlist.scroll -command "$w.userlist.list yview"
	listbox $w.userlist.list -font $USER_LIST_FONT -yscroll "$w.userlist.scroll set" -relief raised -geometry 58x30
	label $w.userlist.label -relief raised -font $USER_LIST_FONT -anchor w -text "USER NAME  REAL NAME                  GROUP NAME  SHELL"
	pack append $w.userlist $w.userlist.label {top fillx} $w.userlist.scroll {right expand fill} $w.userlist.list {right fill}
	bind $w.userlist.list <3> {userlist_moveto {} [.userlist.list nearest %y]}
	bind $w.userlist.list <B2-Motion> {.userlist.list xview 0}
}

proc userlist_update { w passwd_text group_text} \
{
	upvar #0 tmp_passwd_text([expr "{$w} == {} ? {.} : {$w}"]) tmp_passwd_text
	set tmp_passwd_text $passwd_text
	foreach passwd_entry $passwd_text \
	{
		set passwd_entry [file_to_normal $passwd_entry]
		$w.userlist.list insert end \
			 [pad_space [passwd_get_username $passwd_entry] 9 2 \
			][pad_space [passwd_get_realname $passwd_entry] 25 2 \
			][pad_space [group_translate $group_text [passwd_get_gid $passwd_entry]] 10 2 \
			][pad_space [file tail [passwd_get_login_shell $passwd_entry]] 8 0]
	}
}

proc userlist_get_user_entry { w index } \
{
	return [string range [$w.userlist.list get $index] 0 57]
}

proc userlist_get_tag_list { w index } \
{
	return [string range [$w.userlist.list get $index] 59 end]
}

proc userlist_tag { w index tag } \
{
	set user_entry [userlist_get_user_entry $w $index]
	set tag_list [lunion [userlist_get_tag_list $w $index] $tag]
	$w.userlist.list delete $index
	$w.userlist.list insert $index "$user_entry $tag_list"
}

proc userlist_tag_find { w tag } \
{
	set size [$w.userlist.list size]
	for {set i 0} {$i<$size} {incr i} \
	{
		set tag_list [userlist_get_tag_list $w $i]
		set index [lsearch $tag_list $tag]
		if $index!=-1 {return $i}
	}
	return -1
}

proc userlist_tag_remove { w i user_entry tag } \
{
	set tag_list [userlist_get_tag_list $w $i]
	set index [lsearch $tag_list $tag]
	if {$index > -1} \
	{
		set tag_list [lreplace $tag_list $index $index]
		$w.userlist.list delete $i
		$w.userlist.list insert $i "$user_entry $tag_list"
	}
}

proc userlist_tag_propogate {w index} \
{
	set tag_list [userlist_get_tag_list $w $index]
	set prop_tag_list {}
	foreach tag $tag_list \
	{
		if {[string match ".add-*" $tag] == 1} \
		{
			lappend prop_tag_list $tag
		}
	}
	if {$index > 0} \
	{
		set index [expr "$index - 1"]
	} else \
	{
		set index [expr "$index + 1"]
	}
	if {$index < [$w.userlist.list size]} \
	{
		userlist_tag $w $index $prop_tag_list
	}
}

proc userlist_tag_destroy_edit_windows {w index} \
{
	set tag_list [userlist_get_tag_list $w $index]
	set edit_tag_list {}
	foreach tag $tag_list \
	{
		if {[string match ".edit-*" $tag] == 1} \
		{
			lappend edit_tag_list $tag
		}
	}
	set children [winfo children [expr "{$w} == {} ? {.} : {$w}"]]
	foreach win $edit_tag_list \
	{
		if {[lsearch $children $win] > -1} {destroy $win}
	}
}

proc userlist_delete {w} \
{
	set index [lreverse [lnumsort [$w.userlist.list curselection]]]
	if {$index == {}} return
	foreach i $index \
	{
		if { [lsearch [userlist_get_tag_list $w $i] ".edit-*"] > -1 } \
		{
			userlist_tag $w $i .delete
		} else \
		{
			userlist_delete_user $w $i
		}
	}
	userlist_delete_handler $w
}

proc userlist_delete_user {w index} \
{
	upvar #0 tmp_passwd_text([expr "{$w} == {} ? {.} : {$w}"]) tmp_passwd_text
	userlist_tag_propogate $w $index
	userlist_tag_destroy_edit_windows $w $index
	$w.userlist.list delete $index
	upvar #0 userlist_deleted deleted_users
	lappend deleted_users [lindex $tmp_passwd_text $index]
	set tmp_passwd_text [lreplace $tmp_passwd_text $index $index]
}

proc userlist_delete_handler {w} \
{
	upvar #0 active_delete active
	if {$active == 1} return
	set active 1
	upvar #0 tmp_passwd_text([expr "{$w} == {} ? {.} : {$w}"]) tmp_passwd_text
	while {1} \
	{
		set index [userlist_tag_find $w .delete]
		if {$index != -1} \
		{
			userlist_tag_remove $w $index [userlist_get_user_entry $w $index] .delete
			userlist_tag $w $index .delete-current
			set passwd_entry [file_to_normal [lindex $tmp_passwd_text $index]]
			set user "[passwd_get_username $passwd_entry]"
			set realname [passwd_get_realname $passwd_entry]
			if {$realname != {}} {set user "$user ($realname)"}
			if {[query "User $user is currently being edited.  Do you wish to delete?"] == 1} \
			{
				set index [userlist_tag_find $w .delete-current]
				if {$index != -1} \
				{
					userlist_delete_user $w $index
				}
			} else \
			{
				set index [userlist_tag_find $w .delete-current]
				if {$index != -1} \
				{
					userlist_tag_remove $w $index [userlist_get_user_entry $w $index] .delete-current
				}
			}
		} else {set active 0; return}
	}
}

proc userlist_sort { w } \
{
	set index [$w.userlist.list curselection]
	if {$index == {}} return
	set index_from [lindex $index 0]
	set index_to [lindex $index [expr "[llength $index] - 1"]]
	upvar #0 tmp_passwd_text([expr "{$w} == {} ? {.} : {$w}"]) tmp_passwd_text
	set user_list {}
	foreach i $index \
	{
		lappend user_list [$w.userlist.list get $i]
	}
	$w.userlist.list delete $index_from $index_to
	set user_list [lsort $user_list]
	eval "$w.userlist.list insert {$index_from} $user_list"
	set tmp_passwd_text [eval "lreplace {$tmp_passwd_text} $index_from $index_to [lsort [lrange $tmp_passwd_text $index_from $index_to]]"]
}

proc userlist_up { w } \
{
	set index [$w.userlist.list curselection]
	if {$index == {}} return
	set index_from [lindex $index 0]
	set index_to [lindex $index [expr "[llength $index] - 1"]]
	upvar #0 tmp_passwd_text([expr "{$w} == {} ? {.} : {$w}"]) tmp_passwd_text
	if {$index_from <= 0} return
	set index_from [expr "$index_from - 1"]
	set index_to [expr "$index_to + 1"]
	set user_entry [$w.userlist.list get $index_from]
	$w.userlist.list insert $index_to $user_entry
	$w.userlist.list delete $index_from $index_from
	set passwd_entry [lindex $tmp_passwd_text $index_from]
	set tmp_passwd_text [linsert $tmp_passwd_text $index_to $passwd_entry]
	set tmp_passwd_text [lreplace $tmp_passwd_text $index_from $index_from]
	follow $w.userlist.list $index_from 30
}

proc userlist_down { w } \
{
	set index [$w.userlist.list curselection]
	if {$index == {}} return
	set index_from [lindex $index 0]
	set index_to [lindex $index [expr "[llength $index] - 1"]]
	upvar #0 tmp_passwd_text([expr "{$w} == {} ? {.} : {$w}"]) tmp_passwd_text
	set index_to [expr "$index_to + 1"]
	if {$index_to >= [$w.userlist.list size]} return
	set user_entry [$w.userlist.list get $index_to]
	$w.userlist.list delete $index_to $index_to
	$w.userlist.list insert $index_from $user_entry
	set passwd_entry [lindex $tmp_passwd_text $index_to]
	set tmp_passwd_text [lreplace $tmp_passwd_text $index_to $index_to]
	set tmp_passwd_text [linsert $tmp_passwd_text $index_from $passwd_entry]
	follow $w.userlist.list $index_to 30
}

proc userlist_move { w } \
{
	while {[set index [userlist_tag_find $w .move]] != -1} \
	{
		userlist_tag_remove $w $index [userlist_get_user_entry $w $index] .move
	}
	set index [lreverse [lnumsort [$w.userlist.list curselection]]]
	if {$index == {}} return
	set size [$w.userlist.list size]
	foreach i $index \
	{
		userlist_tag $w $i .move
	}
}

proc userlist_moveto {w dest} \
{
	upvar #0 tmp_passwd_text([expr "{$w} == {} ? {.} : {$w}"]) tmp_passwd_text
	set userlist_move {}
	set passwd_move {}
	if {[userlist_tag_find $w .move] == -1} \
	{
		return
	} else \
	{
		userlist_tag $w $dest .moveto
	}
	while {1} \
	{
		set index [userlist_tag_find $w .move]
		if {$index != -1} \
		{
			userlist_moveto_propogate $w $index
			userlist_tag_remove $w $index [userlist_get_user_entry $w $index] .move
			lappend userlist_move [$w.userlist.list get $index]
			lappend passwd_move [lindex $tmp_passwd_text $index]
			$w.userlist.list delete $index
			set tmp_passwd_text [lreplace $tmp_passwd_text $index $index]
		} else \
		{
			set index [userlist_tag_find $w .moveto]
			if {$index != -1} \
			{
				userlist_tag_remove $w $index [userlist_get_user_entry $w $index] .moveto
			} else  {set index 0}
			set index [expr "$index + 1"]
			eval "$w.userlist.list insert $index $userlist_move"
		        set tmp_passwd_text [eval "linsert {$tmp_passwd_text} $index $passwd_move"]
			follow $w.userlist.list $index 30
			follow $w.userlist.list [expr "$index + [llength $userlist_move] - 1"] 30
			return
		}
	}
}
proc userlist_moveto_propogate {w index} \
{
	set tag_list [userlist_get_tag_list $w $index]
	foreach tag $tag_list \
	{
		if {[string match .moveto $tag] == 1} \
		{
			userlist_tag_remove $w $index [userlist_get_user_entry $w $index] .moveto
			if {$index > 0} \
			{
				set index [expr "$index - 1"]
			} else \
			{
				set index [expr "$index + 1"]
			}
			if {$index < [$w.userlist.list size]} \
			{
				userlist_tag $w $index .moveto
			}
			return
		}
	}
}
