# Copyright (c) 1993 by Sanjay Ghemawat
#
# Startup script for text-based ical

############################################################################
# Initialize search paths

if [catch {set libdir $env(ICAL_LIBRARY)}] {
    puts stderr "ical: could not find support library"
    exit 1
}

if [catch {set auto_path}] {
    set auto_path ""
}
set auto_path [concat $libdir $libdir/tcllib $auto_path]

support_init

############################################################################
# Parse arguments

set showcount 1
while {[llength $argv] != 0} {
    set arg [lindex $argv 0]
    set argv [lrange $argv 1 end]

    case $arg in {
	"-calendar" {
	    if {[llength $argv] < 1} usage
	    set calfile [lindex $argv 0]
	    set argv [lrange $argv 1 end]
	}

	"-list" {
	    set showcount 1
	}

	"-show" {
	    if {[llength $argv] < 1} usage
	    set count [lindex $argv 0]
	    set argv [lrange $argv 1 end]

	    if ![regexp {^\+([0-9]+)$} $count junk days] usage
	    set showcount $days
	}

	default {
	    usage
	}
    }
}

############################################################################
# Get calendar

support_init
calendar cal $calfile

############################################################################
# Print listing

set lastdate ""
set sep ""
cal listing [date today] [expr [date today]+$showcount-1] i d {
    if {$d != $lastdate} {
	puts stdout "$sep[date2text $d]"
	set lastdate $d
	set sep "\n"
    }
    puts -nonewline stdout [item2text $i]
}
exit 0
