.TH TmList 3 "24 July 1993"
.SH NAME
.B TmList
- the List widget class
.SH SYNOPSIS
.B list
\ pathName [options]
.br
.SH DESCRIPTION
This is the
.I tcl
binding to the Motif List widget.
.SH CLASSES
The class name for resource files is
.B XmList.
Resources are inherited from
.B TmPrimitive, TmCore.
Commands are inherited from
.B TmCore.
.SH RESOURCES
The new resources are
.IP
automaticSelection
.br
browseSelectionCallback
.br
defaultActionCallback
.br
doubleClickInterval
.br
extendedSelectionCallback
.br
itemCount
.br
items
.br
listMarginHeight
.br
listMarginWidth
.br
listSizePolicy
.br
listSpacing
.br
multipleSelectionCallback
.br
scrollBarDisplayPolicy
.br
selectedItemCount
.br
selectedItems
.br
singleSelectionCallback
.br
stringDirection
.br
topItemPosition
.br
visibleItemCount

.LP
.TP 5 5
.B itemCount
The value for this resource is the number of
.B items.
If this number is different from the actual number of items in the list,
Motif will probably core dump.
.TP 5 5
.B items
The value for this resource is a
string consisting of words separated by commas.
.TP 5 5 
.B selectionPolicy
The values for this resource are
.RS 10
single_select
.br
multiple_select
.br
extended_select
.br
browse_select
.RE 10
.SH COMMANDS
The extra commands supported for this class are
.IP
addItem
.br
deleteItem
.br
deleteAllItems
.br
deletePosition
.br
selectPosition
.LP
.TP 5 5
\fB addItem\fR item position
Add an item to the list at a particular position.
A position of 1 makes it the first, 2 makes it second, etc.
A position of 0 makes it the last item.
.TP 5 5 
\fB deleteItem\fR item
Delete the first matching item from the list.
.TP 5 5
\fB deletePosition\fR position
Delete the item at the position in the list.
.SH "CALLBACK SUBSTITUTIONS
The following substitutions are supported:
.RS 5
.B %item 
- the selected item.
.br
.B %item_position 
- the position of the selected item.
.br
.B %selected_items 
- the list of selected items.
.br
.B %selected_item_count 
- the number of selected items.
.RE 5
.SH BUGS
Before the resource "selectedItems" can be found using getValues,
the value of the
.I tcl 
variable "XmStringTableSize" must be set to
the value of the resource "selectedItemCount" by the
.I tcl 
program.
Otherwise Motif will core dump.

If the number of items is different from the number set in itemCount,
Motif will probably core dump.

The list of items is a string of words separated by commas. This is
recognised as a list by the Motif converter and is not a
.I tcl
list. Sorry about the inconsistency.

.SH AUTHOR
.LP
Jan Newmarch, University of Canberra
