##############################################################################
#
# main.tcl:
#       This file contains the procedures needed to create the toplevel window,
#       the control panel for the program. It also contains some procedures 
#       that don't fit in one of the other categories.
#
# MakeControl {}
#       Make the toplevel window, containing a list of folders, and a button 
#       menu, from which one can manipulate the folders, incorporate mail,
#       compose a message, and call up the alias window.
#
# DisplayFols {}
#       Put the contents of FolList in the folderwindow
#
# CheckForMail {}
#       Check the Maildrop for incoming mail.
#
# InitTkMH {}
#       This procedure sets all the global variables needed to run 
#       tkmh. It first contains global defaults, found in the tkmh.cfg
#       file. It continues reading the .mh_profile, for the appropriate things.
#       Then it reads the .tkmh in the users home directory, and
#       after that it checks environment variables.
#       also initialize global lists like FolList and AliasList
#
# Loop {}
#       The loop used for checking for new mail and so
#
# Refresh {}
#	Kill all the folder, show and edit windows.
#
##############################################################################

proc makeControl {} {
    global BM Aliases PREF FolList

    wm withdraw .
    
    toplevel .tkmh
    wm title .tkmh TkMh
    wm iconbitmap .tkmh @$BM(nomail)

    scrollbar .tkmh.fols -relief raised -command {.tkmh.foll yview}
    listbox .tkmh.foll -setgrid true -yscroll {.tkmh.fols set} \
      -geometry 15x15 -relief raised -borderwidth 2

    frame .tkmh.b -border 1
    button .tkmh.b.quit -text "Quit!" -command {destroy .tkmh; exit}
    button .tkmh.b.inc -bitmap @$BM(nomail) -command "IncMail"
    button .tkmh.b.help -text "Help" -command "Help Control.Window"
    menubutton .tkmh.b.conf -text "Configure" -menu .tkmh.b.conf.m -relief raised
    menubutton .tkmh.b.mail -relief raised -text "Mail To" -menu .tkmh.b.mail.m
    menubutton .tkmh.b.f -relief raised -text "Folder" -menu .tkmh.b.f.m

    menu .tkmh.b.f.m
      .tkmh.b.f.m add command -label "Open" \
        -command {if {[set Sel [GetListboxSel .tkmh.foll]] != ""} {OpenFol $Sel}}
      .tkmh.b.f.m add command -label "Remove" \
        -command {if {[set Fol [GetListboxSel .tkmh.foll]] != ""} {
                    if [RemoveFol $Fol] {BuildFolList; DisplayFols $FolList}}}
      .tkmh.b.f.m add command -label "Rename" \
        -command {if {[set Fol [GetListboxSel .tkmh.foll]] != ""} {
                    if [RenameFol $Fol] {BuildFolList; DisplayFols $FolList}}}
      .tkmh.b.f.m add separator
      .tkmh.b.f.m add command -label "Create New" \
        -command {if {[set Fol [Ask "Folder to Create?"]] != ""} {
                     CreateFol $Fol; BuildFolList; DisplayFols $FolList}}
      .tkmh.b.f.m add separator
      .tkmh.b.f.m add command -label "Pick Folders" -command \
         {if {[set EXPR [Ask "Match against:"]] != {}} {
            set PickList {}
            foreach Fol $FolList {
              if [regexp $EXPR $Fol] {lappend PickList $Fol}
            }
          DisplayFols $PickList
          }}
      .tkmh.b.f.m add command -label "Redisplay Folders" -command \
          {DisplayFols $FolList}

    menu .tkmh.b.conf.m
    .tkmh.b.conf.m add command -label "Aliases" -command AliasWindow
    .tkmh.b.conf.m add command -label "TkMH" -command ConfTkMH
    .tkmh.b.conf.m add command -label "MH" -command \
      {if [Confirm "All Message, Edit and Folder windows will be destroyed.\
                       \nContinue?\n"] {
          Refresh; ConfMH
      }}

    menu .tkmh.b.mail.m
     .tkmh.b.mail.m add command -label *NEW* -command "ComposeMsg"
    MakeAliMenu

     pack append .tkmh.b \
      .tkmh.b.inc {top expand fill} \
      .tkmh.b.conf {top expand fill} \
      .tkmh.b.mail {top expand fill} \
      .tkmh.b.f {top expand fill} \
      .tkmh.b.help {top expand fill} \
      .tkmh.b.quit {top expand fill}

    pack append .tkmh \
      .tkmh.foll {left expand fill} \
      .tkmh.fols {left filly} \
      .tkmh.b {left filly} 

    bind .tkmh.foll <Double-Button-1> {if {[set Sel [GetListboxSel .tkmh.foll]] != ""} {OpenFol $Sel}}
    DisplayFols $FolList
    tk_listboxSingleSelect .tkmh.foll
    .tkmh.b.inc configure -state disabled
}

proc DisplayFols {List} {

    set curYview [lindex [.tkmh.fols get] 2]
    .tkmh.foll delete 0 end
    foreach Fol $List {
        .tkmh.foll insert end $Fol
    }
    .tkmh.foll yview $curYview
}

proc Loop {} {
    global PREF
    
    CheckForMail
    after [expr $PREF(Delay) * 1000] Loop
}

set MDSize 0
set MDOldSize 0

proc CheckForMail {} {
    global MH BM PREF
    global MDSize MDOldSize

    if {![file exists $MH(MailDrop)]} {
        return
    }

    set MDOldSize $MDSize
    set MDSize [file size $MH(MailDrop)]

    if {$MDSize > $MDOldSize} {
        # There is new mail
        .tkmh.b.inc configure -bitmap @$BM(mail) -state active
        wm iconbitmap .tkmh @$BM(mail)
        .tkmh.b.inc flash; .tkmh.b.inc flash
        if $PREF(DeIcon) {wm deiconify .tkmh}
    }

    if {$MDSize < $MDOldSize && $MDSize <= 1} {
        # The maildrop file must be emptied by something else
        .tkmh.b.inc configure -bitmap @$BM(nomail) -state disabled
        wm iconbitmap .tkmh @$BM(nomail)
    }
}

proc IncMail {} {
    global MH BM PREF

    # the check is normally not needed, but just in case something 
    # outside TkMH is working at the maildrop at the same time, or
    # the maildrop is not accessible for some reason
    if {[catch {exec $MH(bindir)/inc +$MH(Inbox)}] == 1} {
        MsgWindow "Something wrong with the Maildrop file!\
                   \nMaybe it's locked because you were just receiving mail.\
                   \n\n Try again.\n"
        return
    }

    .tkmh.b.inc configure -bitmap @$BM(nomail) -state disabled
    wm iconbitmap .tkmh @$BM(nomail)
    if $PREF(OpenInbox) {
        OpenFol $MH(Inbox)
    }
}

proc Refresh {} {
    set WinList [winfo children .]
    foreach Win $WinList {
        if {[string match .fol* $Win] || [string match .show* $Win] || \
            [string match .edit* $Win]} {
            destroy $Win
        }
    }
}
