# use_palette.tcl
# 
# Copyright (c) 1994 R"udiger Franke
# All Rights Reserved.
# 
# Redistribution and use in any form, with or without modification, 
# is permitted, provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in other form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#       This product includes software developed by R"udiger Franke.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# constructor for "use_palette"
#
proc use_palette {w  args} {
  upvar #0 $w this

  # user initializations

  set this(elements) {}
  set this(ncolumns) 3
  # data initializations

  set this(use_palette) $w
  
  # widget creations

  frame $this(use_palette) -class Use_palette
  
  useCreateComponent use_palette $w $args

  # user additions

  # initialize a table for managing children
  blt_table $w

  return $w
}

#
# method "insert"
#
proc use_palette::insert {w widgets} {
  upvar #0 $w this

  set this(elements) [lsort [concat $this(elements) $widgets]]
  $w layout
}

#
# method "layout"
#
proc use_palette::layout {w } {
  upvar #0 $w this

  # forget current slaves
  
  foreach slave [blt_table slaves $w] {
    blt_table forget $slave
  }
  
  # rearrage elements
  
  set row 0
  set col 0
  foreach element $this(elements) {
    blt_table $w \
      $element $row,$col -fill both -padx 2 -pady 2
    incr col
    if {$col >= $this(ncolumns)} {
      set col 0
      incr row
    }
  }
}

#
# method "ncolumns"
#
proc use_palette::ncolumns {w {ncols {}}} {
  upvar #0 $w this

  if {$ncols == {}} {
    return $this(ncolumns)
  } else {
    set this(ncolumns) $ncols
    $w layout
  }
}

#
# method "release"
#
proc use_palette::release {w widgets} {
  upvar #0 $w this

  foreach widget $widgets {
    set index [lsearch $this(elements) $widget]
    if {$index >= 0} {
      set this(elements) [lreplace $this(elements) $index $index]
    }
  }
  $w layout
}

