#
# Source: 	use_widgets.tcl
# Author: 	rf, 12/30/93
# Version: 	0.1
# Description:
#   - user interface component for a palette of components
#

proc use_widgets { w comps args} {
   upvar #0 $w this

   frame $w -class Use_widgets
   label $w.name -text [winfo name $w]
   frame $w.comps

   pack $w.name -fill x
   pack $w.comps -fill both -expand true

   foreach comp $comps {
      set wname [string tolower $comp]
      label $w.comps.$wname \
         -text $comp \
         -anchor w \
         -relief groove
      pack $w.comps.$wname -fill both -expand true

      blt_drag&drop source $w.comps.$wname config \
         -packagecmd "package_wcommand $comp"
      blt_drag&drop source $w.comps.$wname handler wcommand dd_send_wcommand
   }

   useCreateComponent use_widgets $w $args

   set this(name) {}
   return $w
}

proc use_widgets::name { w name} {

   $w.name configure -text $name
}


proc package_wcommand { wclass token} {

   if {[winfo children $token] == ""} {
      label $token.dd_wclass -text $wclass
      pack $token.dd_wclass
   }

   return [string tolower $wclass]
} 
   
