# use_wpalette.tcl
# 
# Copyright (c) 1994 R"udiger Franke
# All Rights Reserved.
# 
# Redistribution and use in any form, with or without modification, 
# is permitted, provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in other form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#       This product includes software developed by R"udiger Franke.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# constructor for "use_wpalette"
#
proc use_wpalette {w title widgets args} {
  upvar #0 $w this

  # data initializations

  set this(use_wpalette) $w
  set this(title) $w.title
  set this(palette) $w.palette
  
  # widget creations

  frame $this(use_wpalette) -class Use_wpalette
  label $this(title)  \
    -text "$title"
  frame $this(palette) 
  
  # widget layouting

  pack $this(title) -fill x
  pack $this(palette) -fill both -expand true
  
  useCreateComponent use_wpalette $w $args

  # user additions

  # create labels for palettes widgets
  set i 0
  foreach widget $widgets {
    set wname widget$i
    set wpath $this(palette).$wname
    label $wpath \
      -text $widget \
      -anchor w \
      -bd 1 -relief raised
     pack $wpath -fill both -expand true
  
     blt_drag&drop source $wpath config \
       -packagecmd "$w package_wcommand $widget"
     blt_drag&drop source $wpath handler wcommand dd_send_wcommand
  
     incr i
  }
  

  return $w
}

#
# method "package_wcommand"
#
proc use_wpalette::package_wcommand {w widget token} {
  upvar #0 $w this

  if {[winfo children $token] == ""} {
    label $token.dd_wcmd -text $widget
    pack $token.dd_wcmd
  }
  
  return [string tolower $widget]
  
}

