'\"
'\" Copyright 1992 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" Copyright 1993 by AT&T Bell Laboratories.
'\" Permission to use, copy, modify, and distribute this software
'\" and its documentation for any purpose and without fee is hereby
'\" granted, provided that the above copyright notice appear in all
'\" copies and that both that the copyright notice and warranty
'\" disclaimer appear in supporting documentation, and that the
'\" names of AT&T Bell Laboratories any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the
'\" software without specific, written prior permission.
'\"
'\" AT&T disclaims all warranties with regard to this software, including
'\" all implied warranties of merchantability and fitness.  In no event
'\" shall AT&T be liable for any special, indirect or consequential
'\" damages or any damages whatsoever resulting from loss of use, data
'\" or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or
'\" performance of this software.
'\"
'\" Window command created by George Howlett.
'\"
.so man.macros
.HS blt_win cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
blt_win \- Perform assorted window operations
.SH SYNOPSIS
\fBblt_win raise \fIwindow\fR
.sp
\fBblt_win lower \fIwindow\fR
.sp
\fBblt_win map \fIwindow\fR 
.sp
\fBblt_win unmap \fIwindow\fR 
.BE
.SH DESCRIPTION
.PP
This command performs assorted window operations on Tk windows.
Windows may be raised, lower, map, or unmapped.
.PP
The \fBblt_win\fR command can take any of the following forms:
.TP
\fBblt_win lower \fIwindow\fR 
Lowers a window to the bottom of the X window stack.  \fIWindow\fR must 
be a valid path name of a Tk window.  
.TP
\fBblt_win map \fIwindow\fR 
Maps the window again.
\fIWindow\fR must be the path name of a Tk window.
If \fIwindow\fR is already mapped, this command has no effect.
This command returns the empty string.
.TP
\fBblt_win raise \fIwindow\fR
Raises the window to the top of the X window stack. \fIWindow\fR must be
a valid path name of a Tk window.  This command returns the empty string.
.TP
\fBblt_win unmap \fIwindow\fR 
Unmaps the \fIwindow\fR. \fIWindow\fR must be a valid path name of a Tk
window. This command returns the empty string.
.SH KEYWORDS
window
