
#ifndef _ELEMENT_H
#define _ELEMENT_H

/*
 * A tag can be either a text string, bitmap, or straight line,
 * window or polygon.
 */
typedef enum {
    LINE_ELEM_TYPE, BAR_ELEM_TYPE
} ElementClassType;

typedef enum {
    LINE_SYMBOL, SQUARE_SYMBOL, CIRCLE_SYMBOL, DIAMOND_SYMBOL,
    PLUS_SYMBOL, CROSS_SYMBOL
} SymbolType;

/*
 * The data structure below contains information pertaining to a line
 * vector.  It consists of an array of floating point data values and
 * for convenience, the number and minimum/maximum values.
 */
typedef struct Vector {
    double *data;		/* Array of values */
    int length;			/* Number of entries in the array */
    double min, max;		/* Smallest/largest values in the array */
    double logMin;		/* Smallest positive value */
} Vector;

/*
 * An element has one or more vectors plus several attributes,
 * such as line style, thickness, color, and symbol type.  It
 * has an identifier which distinguishes it among the list of all
 * elements.
 */
typedef struct Element Element;

typedef void (ElemDisplayProc) _ANSI_ARGS_((Graph *, Element *));
typedef void (ElemDestroyProc) _ANSI_ARGS_((Graph *, Element *));
typedef int (ElemConfigProc) _ANSI_ARGS_((Graph *, Element *));
typedef void (ElemLayoutProc) _ANSI_ARGS_((Graph *, Element *));
typedef void (ElemPrintProc) _ANSI_ARGS_((Graph *, Element *));
typedef int (ElemLimitsProc) _ANSI_ARGS_((Element *, enum AxisTypes, int,
	double *, double *));
typedef double (ElemDistanceProc) _ANSI_ARGS_((Graph *, Element *, int, int, 
	int *));
typedef void (ElemDrawSymbolsProc) _ANSI_ARGS_((Graph *, Element *, int,
	XPoint *, int));
typedef void (ElemPrintSymbolsProc) _ANSI_ARGS_((Graph *, Element *, int,
	XPoint *, int));

struct Element {
    Tcl_Interp *interp;		/* Interpreter of graph widget */
    ElementClassType type;	/* Type of element; either BAR_ELEMENT or
				 * LINE_ELEMENT */
    unsigned int flags;
    Tk_Uid id;			/* Identifier to refer the element. Used in
				 * the "insert", "delete", or "show",
				 * commands. */
    int mapped;			/* If true, element is currently visible. */
    Tk_ConfigSpec *configSpecs;	/* Configuration specifications */
    char *label;		/* Label displayed in legend */
    SymbolType symbol;		/* Element symbol type */
    double symbolScale;		/* Size of symbol as a percentage of the
				 * drawing area. */
    int symbolSize;		/* Computed size of symbol in pixels. */

    Vector x, y;		/* Contains array of floating point graph
				 * coordinate values. Also holds min/max and
				 * the number of coordinates */

    ElemConfigProc *configProc;
    ElemDestroyProc *destroyProc;
    ElemDisplayProc *displayProc;
    ElemLimitsProc *limitsProc;
    ElemDistanceProc *distProc;
    ElemLayoutProc *layoutProc;
    ElemPrintProc *printProc;
    ElemDrawSymbolsProc *drawSymbolsProc;
    ElemPrintSymbolsProc *printSymbolsProc;

};

#endif /* _ELEMENT_H */
