#----------------------------------------------------------------------
#
#         S t a n d a r d   D i a l o g   B u t t o n s
#
#----------------------------------------------------------------------
proc tixStdDlgBtns {w args} {
    eval tixInt_CreateWidget $w tixSdb TixStdDlgBtns $args
    return $w
}

proc tixStdDlgButtons {w args} {
    eval tixInt_CreateWidget $w tixSdb TixStdDlgBtns $args
    return $w
}

proc tixSdb::CreateClassRec {} {
    global tixSdb

    # OPTIONS
    set tixSdb(rootOptions)   {}
    set tixSdb(options)       {-background -state -buttonbg -font -bg \
                               -foreground -fg}

    # DEFAULT VALUES
    set tixSdb(-background)   {-background background Background #ffe4c4}
    set tixSdb(-foreground)   {-foreground foreground Foreground black}
    set tixSdb(-state)        {-state state State normal}
    set tixSdb(-buttonbg)     {-buttonbg buttonBg Background #ffe4c4}
    set tixSdb(-font)         {-font Font Font \
	                     "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"}
    # ALIASES
    set tixSdb(-bg)           {= -background}
    set tixSdb(-fg)           {= -foreground}

    # METHODS
    set tixSdb(methods)       {ok apply cancel help}
}

proc tixSdb::ConstructWidget {w} {
   upvar #0 $w data

   set data(ok)     [button $w.b1 -text "OK"     -width 6 \
		     -bg $data(-buttonbg) -font $data(-font)\
		     -fg $data(-foreground)]
   set data(apply)  [button $w.b2 -text "Apply"  -width 6 \
		     -bg $data(-buttonbg) -font $data(-font)\
		     -fg $data(-foreground)]
   set data(cancel) [button $w.b3 -text "Cancel" -width 6 \
		     -bg $data(-buttonbg) -font $data(-font)\
		     -fg $data(-foreground)]
   set data(help)   [button $w.b4 -text "Help"   -width 6 \
		     -bg $data(-buttonbg) -font $data(-font)\
		     -fg $data(-foreground)]

   pack $w.b1 $w.b2 $w.b3 $w.b4 \
       -side left -expand yes -padx 10 -pady 15 -fill y

   if {$data(-state) == "disabled"} {
       tixSdb::config-state $w disabled
   }
}

proc tixSdb::InitWidgetRec {w class className args} {
    upvar #0 $w data
}

#----------------------------------------------------------------------
#                           CONFIG OPTIONS
#----------------------------------------------------------------------
proc tixSdb::config-background {w arg} {
    upvar #0 $w data

    $data(rootCmd) config -bg $arg
}

proc tixSdb::config-buttonbg {w arg} {
    upvar #0 $w data

    foreach btn {ok apply cancel help} {
	$data($btn) config -bg $arg
    }
} 

proc tixSdb::config-font {w arg} {
    upvar #0 $w data

    foreach btn {ok apply cancel help} {
	$data($btn) config -font $arg
    }
} 

proc tixSdb::config-state {w arg} {
    upvar #0 $w data

    if {$arg == $data(-state)} {
	return
    } else {
	foreach btn {ok apply cancel help} {
	    $data($btn) config -state $arg
	}
    }
}

#----------------------------------------------------------------------
# Methods
#                     WIDGET COMMANDS
#----------------------------------------------------------------------
proc tixSdb::ok {w args} {
    upvar #0 $w data

    if {$args == {}} {
	return $data(ok)
    } else {
	return [eval $data(ok) $args]
    }
}

proc tixSdb::ok {w args} {
    upvar #0 $w data

    if {$args == {}} {
	return $data(ok)
    } else {
	return [eval $data(ok) $args]
    }
}

proc tixSdb::apply {w args} {
    upvar #0 $w data

    if {$args == {}} {
	return $data(apply)
    } else {
	return [eval $data(apply) $args]
    }
}

proc tixSdb::cancel {w args} {
    upvar #0 $w data

    if {$args == {}} {
	return $data(cancel)
    } else {
	return [eval $data(cancel) $args]
    }
}

proc tixSdb::help {w args} {
    upvar #0 $w data

    if {$args == {}} {
	return $data(help)
    } else {
	return [eval $data(help) $args]
    }
}
