#include "allg.h"
#include "c++.h"
#include "m_color.new.h"
#include "tkConfig.h"
#include "tkInt.h"

extern Tk_Window tkpcwindow; /* TkPC */
extern "C" {
extern int TkPC_testpixmap(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[]);
}


int TkPC_testpixmap(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
 // --------- Testweise hier eingefuegt: muss spaeter einen eigenen Callback haben
   Display *display = Tk_Display(tkpcwindow);

   Window root;
   int screen;
   int x ,y;
   unsigned int border_width ;
   unsigned long *pixels;
   int done;
   Status status;
   unsigned short comp;
   unsigned long l;
  
   float z;
   float x_real, y_real, x_ziel, y_ziel;
   Arg args[20];
   Visual *visual;   
   unsigned int depth; 
   int format = ZPixmap; 
   int offset = 0;  
   char *data;   
   unsigned int width;   
   unsigned int height; 
   unsigned int w0, h0;
   int bitmap_pad;   
   int bytes_per_line; 
   XImage *image;   
   register int i ,j ;
   register int p1;

   int max_color;
   int off_color;    
   TkPC_object *this_cmap;
   char cname[256];

   TkPC_CmapName_by_WidgetName(interp, ".", cname);
 
   this_cmap = TkPC_Find(cname);
   if( this_cmap == 0 ) {
      // Fehler keine colormap ueber den Tk_Server definiert
      return(TCL_OK);
   }
   max_color = this_cmap->maxcolor();
   off_color = this_cmap->offcolor(); //Dies ist der Offset in der Farbtafel

   static Pixmap pixmap = 0;
   Tk_Uid pixId = Tk_GetUid("demopixmap");
   int len_x = 256; // width of pixmap
   int len_y = 32; // height of pixmap

   if( pixmap == 0 ) {
      if ( Tk_DefinePixmap(interp, pixId, (int) NULL, (int) NULL, (int) NULL, None,
                            len_x, len_y, 0, "xpm3") != TCL_OK ) {
          cerr << "tkpc_demo: " << interp->result << endl;
          exit(1);
      }
   }
   if ( (pixmap = Tk_GetPixmap(interp, tkpcwindow, pixId)) == None ) {
       cerr << "tkpc_demo: " << interp->result << endl;
       exit(1);
   }
   screen = DefaultScreen ( display );

   status = XGetGeometry( display, pixmap, &root, &x , &y, &width, &height,
&border_width, &depth);

   GC mygc = XCreateGC (display, pixmap, 0, 0);

   visual = DefaultVisual(display, screen);

   format = ZPixmap;

   bitmap_pad = 8;

   if(depth > 8)
     bitmap_pad = 32;

   image = XCreateImage( display, visual, depth, format, 0, 0, len_x, len_y, bitmap_pad, 0);

   if ( image == NULL ) { /* Zuweisung der Image-Struktur misslungen */
       fprintf(stderr,"Image konnte nicht zugewiesen werden !\n");
       return TCL_OK;
   }
   image->data = (char *) malloc( image->bytes_per_line * len_y );
   if( image->data == NULL ) { /* malloc - fehler */
       fprintf(stderr,"Zuwenig Speicher!\n");
       return TCL_OK;
   }


   pixels = this_cmap->pixels();
   if( max_color > 0 ) {
      int dummy = max_color - 1;
      for( j = 0; j < width; j++) {
          p1 = (int) ( (float)j * (float)(max_color-off_color) / ((float)width) ) ;
          p1 += off_color;
          if (p1 >= max_color) {
             p1 = dummy;
          } else if ( p1 < off_color ) {
             p1 = off_color;
          }
          for( i = 0; i < height; i++) {
             XPutPixel( image, j, i, pixels[p1] );
          }
   }
   XPutImage(display, pixmap, mygc, image, 0, 0, 0, 0, len_x, len_y);
   }

   free(image->data);
   XFree((char *)image);
   XFreeGC(display, mygc);
   i  = 0;
   return TCL_OK;
}

// end of modul m_color.cc
