#
# GraphicalObject.tcl,v 1.1.1.1 1992/05/08 19:46:04 snl Exp
#
# /afs/cs/project/edrc/ndim/source/bos/base/GraphicalObject.tcl,v 1.1.1.1 1992/05/08 19:46:04 snl Exp
#
# HISTORY
# GraphicalObject.tcl,v
# Revision 1.1.1.1  1992/05/08  19:46:04  snl
# bos 1.2
#
# Revision 1.1  92/03/08  23:33:09  snl
# Initial revision
# 
# Revision 1.2  92/01/27  16:06:07  snl
# Port to new TCL
# 
# Revision 1.1  91/12/16  20:11:39  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:41:59  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:34:26  snl
# Initial revision
# 
# Revision 2.2  91/10/25  17:04:45  snl
# 	<<<log message for ./tcl/base/GraphicalObject.tcl>>>
# 
#
Set refineWith GraphicalObject

GraphicalObjectTraits defMethod initialize {parentObject} {
  $self initializePhase1 $parentObject
  $self initializePhase2 $parentObject
  return [$self window]
}
GraphicalObjectTraits defMethod initializePhase1 {parentObject} {
  if {[expr {[$parentObject index $self] != -1}]} {
    error [format "GraphicalObject %s already contains an object named %s" \
           $parentObject $self]
  }
  if {[string compare [$self window] ""]} {
    $self uninitialize
  }
  $self set window [$self _deriveWindowName [$parentObject window]]
  return [$self window]
}
GraphicalObjectTraits defMethod initializePhase2 {parentObject} {
  $parentObject put $self
  $self set parentObject $parentObject
  return $self
}
GraphicalObjectTraits defMethod uninitialize {} {
  foreach c [$self contents] {
    catch {$c uninitialize}
    $self take [$self index $c]
  }
  if {[string compare [$self window] .]} {
    catch {destroy [$self window]}
  }
  $self set window {}
  $self set parentObject {}
}
GraphicalObjectTraits defMethod die {} {
  $self uninitialize
  return [$self [$self setParent]:die]
}
GraphicalObjectTraits defMethod _deriveWindowName {parentWindowName} {
  if {![string compare $parentWindowName .]} {
    return [format ".%s" $self]
  } else {
    return [format "%s.%s" $parentWindowName $self]
  }
}
GraphicalObjectTraits defMethod winfo {what} {
  set w [$self window]
  if {[string compare $w ""]} {
    return [winfo $what $w]
  } else {
    return {}
  }
}
GraphicalObjectTraits defMethod config {args} {
  eval "[$self window] config $args"
}
GraphicalObjectTraits defMethod move {x y} {
  set w [$self window]
  if {[string compare $w ""]} {
    move $w $x $y
  }
}
GraphicalObjectTraits defMethod bind {pattern {command {}}} {
  set w [$self window]
  if {[string compare $w ""]} {
    if {![string compare $command ""]} {
      return [bind $w $pattern]
    } else {
      return [bind $w $pattern $command]
    }
  }
}
GraphicalObjectTraits defMethod resize {width height} {
  resize [$self window] $width $height
}
GraphicalObjectTraits defMethod geometry {width height} {
  geometry [$self window] $width $height
}
GraphicalObjectTraits defMethod map {} {
  map [$self window]
}
GraphicalObjectTraits defMethod pack {option {args}} {
  eval "pack $option [$self window] $args"
}
GraphicalObjectTraits defMethod desiredSize {} {
  resize [$self window] [$self winfo reqwidth] [$self winfo reqheight]
  geometry [$self window] [$self winfo reqwidth] [$self winfo reqheight]
  return [list [$self winfo reqwidth] [$self winfo reqheight]]
}
GraphicalObjectTraits defMethod shortWindowName {} {
  return [string range [file extension [$self window]] 1 end]
}

GraphicalObject addSlot window {}
GraphicalObject addSlot parentObject {}
