#
# Menu.tcl,v 1.2 1992/08/11 15:22:03 snl Exp
#
# /afs/cs/project/edrc/ndim/source/bos/base/Menu.tcl,v 1.2 1992/08/11 15:22:03 snl Exp
#
# HISTORY
#
# Menu.tcl,v
# Revision 1.2  1992/08/11  15:22:03  snl
# updated makefiles, finished 0.90 freeze
#
# Revision 1.1.1.1  1992/05/08  19:46:07  snl
# bos 1.2
#
# Revision 1.1  92/03/08  23:33:17  snl
# Initial revision
# 
# Revision 1.2  92/01/27  16:06:18  snl
# Port to new TCL
# 
# Revision 1.1  91/12/16  20:11:52  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:42:11  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:34:35  snl
# Initial revision
# 
#
GraphicalObject refineWith Menu

MenuTraits defMethod initialize {parent args} {
  set w [$self [$self graphicalObjectParent]:initialize $parent]
  eval "menu $w $args"
  $self bind <Any-Enter> "$self activate @%y"
  $self bind <Any-Leave> "$self activate none"
  $self bind <Any-Motion> "$self activate @%y"
  $self bind <ButtonRelease-1> "$self invokeActive"
  return $w
}
MenuTraits defMethod addButton {label command} {
#  if {[expr {[$self index $label] != -1}]} {
#    error [format "Menu %s already has a button called %s" $self $label]
#  }
  [$self window] add command -label $label -command $command
  return $label
}
MenuTraits defMethod addSeparator {} {
  [$self window] add sep
  return $self

}
MenuTraits defMethod addCascade {label menu} {
  if {[expr {[$self index $label] != -1}]} {
    error [format "Menu %s already has a cascade called %s" $self $label]
  }
  [$self window] add cascade -label $label -menu [$menu window]
  return $label
}
MenuTraits defMethod entryConfigure {index args} {
  eval "[$self window] entryconfigure $index $args"
}
MenuTraits defMethod delete {index} {
  [$self window] delete $index
}
MenuTraits defMethod numberOfEntries {} {
  for {set i 0} {$i == $i} {++ i} {
    if {[catch {$self entryConfigure $i}]} {
      break
    }
  }
  return $i

}
MenuTraits defMethod clear {} {
  set n [$self numberOfEntries]
  for {set i 0} {$i < $n} {++ i} {
    $self delete 0
  }
}
MenuTraits defMethod activate {what} {
  [$self window] activate $what
}
MenuTraits defMethod invokeActive {} {
  [$self window] invoke active
}
MenuTraits defMethod post {X Y {group {}}} {
  eval "[$self window] post $X $Y $group"
}
MenuTraits defMethod unpost {} {
  [$self window] unpost
}
