#
# MenuButton.tcl,v 1.1.1.1 1992/05/08 19:46:07 snl Exp
#
# /afs/cs/project/edrc/ndim/source/bos/base/MenuButton.tcl,v 1.1.1.1 1992/05/08 19:46:07 snl Exp
#
# HISTORY
#
# MenuButton.tcl,v
# Revision 1.1.1.1  1992/05/08  19:46:07  snl
# bos 1.2
#
# Revision 1.1  92/03/08  23:33:25  snl
# Initial revision
# 
# Revision 1.2  92/01/27  16:06:22  snl
# Port to new TCL
# 
# Revision 1.1  91/12/16  20:11:59  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:42:16  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:34:43  snl
# Initial revision
# 
#
GraphicalObject refineWith MenuButton

MenuButtonTraits defMethod initialize {parent {label ""} args} {
  set w [$self [$self graphicalObjectParent]:initializePhase1 $parent]
  if {![string compare $label ""]} {set label $self}
  eval "menubutton $w -text $label $args"
  $self [$self graphicalObjectParent]:initializePhase2 $parent
  $self bind <Enter> "$self activate"
  $self bind <B1-Enter> "$self activate; $self config -relief sunken;$self post"
  $self bind <B1-Leave> "$self deactivate; $self config -relief flat"
  $self bind <Shift-B1-Leave> "$self deactivate; $self config -relief flat"
  $self bind <Leave> "$self deactivate"
  $self bind <1> "$self config -relief sunken; $self post"
  $self bind <ButtonRelease-1> "$self config -relief flat; $self unpost"
  return $w
}
MenuButtonTraits defMethod activate {} {
  [$self window] activate
}
MenuButtonTraits defMethod deactivate {} {
  [$self window] deactivate
}
MenuButtonTraits defMethod post {} {
  [$self window] post
}
MenuButtonTraits defMethod unpost {} {
  [$self window] unpost
}
MenuButtonTraits defMethod setMenu {menu} {
  $self config -menu [$menu window]
  return $menu
}
