#
# laytree.tcl,v 1.1 1992/05/21 04:07:35 snl Exp
#
# /afs/cs/project/edrc/ndim/source/bos/base/laytree.tcl,v 1.1 1992/05/21 04:07:35 snl Exp
#
# HISTORY
#
# laytree.tcl,v
# Revision 1.1  1992/05/21  04:07:35  snl
# moved in some files from ndim/workspace
#
# Revision 1.1.1.1  1992/05/08  19:32:03  snl
# n-dim 0.82
#
# Revision 1.2  92/01/27  15:49:16  snl
# Port to new TCL
# 
# Revision 1.1  91/12/16  20:22:08  snl
# Initial revision
# 
#
global _laytree_hgap_
global _laytree_vgap_

set _laytree_hgap_ 20
set _laytree_vgap_ 20

proc laytree {coll} {
  set root [tree-root $coll]
  if {![llength $root]} {return}
#  unmap $coll
  global _laytree_orient_
  set cw [winfo width $coll]
  set ch [winfo height $coll]
  if {[string compare $_laytree_orient_ vertical]} {
    _laytreeh $coll $root 20 [expr {$ch/2}]
  } else {
    _laytreev $coll $root [expr {$cw/2}] 20
  }
  map $coll
}

proc layout {coll} {
  set roots [all-roots $coll]
  if {![llength $roots]} {return}
  global _laytree_orient_
  update
  set cw [winfo width $coll]
  set ch [winfo height $coll]
  set nx 20
  set ny 20
  foreach r $roots {
    if {[string compare $_laytree_orient_ vertical]} {
      set wh [_laytreeh $coll $r 20 $ny]
      set ny [expr {$ny + [lindex $wh 1] + 20}]
    } else {
      set wh [_laytreev $coll $r $nx 20]
      set nx [expr {$nx + [lindex $wh 0] + 20}]
    }
  }
}

proc _laytreev {coll root {x 20} {y 20}} {
# const
  global _laytree_hgap_
  global _laytree_vgap_

  set vgap $_laytree_vgap_
  set hgap $_laytree_hgap_

  set name $coll.$root
  set subtreex $x
  set subtreey [expr "$y + $vgap + [winfo height $name]"]
  set maxheight 0
  foreach subtree [$coll from $root] {
    set subtreewh [_laytreev $coll $subtree $subtreex $subtreey]
    set subtreex [expr "$subtreex + $hgap + [lindex $subtreewh 0]"]
    if {[lindex $subtreewh 1] > $maxheight} {
      set maxheight [lindex $subtreewh 1]
    }
  }
  set treew [expr "$subtreex - $x - $hgap"]
  if {[winfo width $name] > $treew} {
    set treew [winfo width $name]
  }
  set treeh [expr "[winfo height $name] + $vgap + $maxheight"]
  set treewh "$treew $treeh"
  set x  [expr "$x + $treew/2-[winfo width $name]/2"]
  if {[string compare [winfo x $name] $x] ||
      [string compare [winfo y $name] $y]} {
    move $name $x $y
  }
  return $treewh
}

proc _laytreeh {coll root {x 20} {y 20}} {
# const
  global _laytree_hgap_
  global _laytree_vgap_

  set vgap $_laytree_vgap_
  set hgap $_laytree_hgap_

  set name $coll.$root
  set subtreey $y
  set subtreex [expr "$x + $hgap + [winfo width $name]"]
  set maxwidth 0
  foreach subtree [$coll from $root] {
    set subtreewh [_laytreeh $coll $subtree $subtreex $subtreey]
    set subtreey [expr "$subtreey + $vgap + [lindex $subtreewh 1]"]
    if {[lindex $subtreewh 0] > $maxwidth} {
      set maxwidth [lindex $subtreewh 0]
    }
  }
  set treeh [expr "$subtreey - $y - $vgap"]
  if {[winfo height $name] > $treeh} {
    set treeh [winfo height $name]
  }
  set treew [expr "[winfo width $name] + $hgap + $maxwidth"]
  set treewh "$treew $treeh"
  set y  [expr "$y + $treeh/2-[winfo height $name]/2"]
  if {[string compare [winfo x $name] $x] ||
      [string compare [winfo y $name] $y]} {
    move $name $x $y
  }
  return $treewh
}

proc tree-root {coll} {
  set rootno 0
  set root ""
  set children [winfo children $coll]
  if {![llength $children]} {return {}}
  foreach c $children {
    set tono [llength [$coll to $c]]
    if {$tono == 0} {
      ++ rootno
      set root [winfo name $c]
    } else {if {$tono > 1} {set rootno 23}}
  }
  if {$rootno != 1} {
    puts stdout "not a tree\n"
    return ""
  }
  return $root
}

proc all-roots {coll} {
  set roots {}
  set children [winfo children $coll]
  if {![llength $children]} {return {}}
  foreach c $children {
    set tono [llength [$coll to $c]]
    if {$tono == 0} {
      set roots [concat $roots [winfo name $c]]
    }
  }
  return $roots
}
