# tree layout procedures
# dino@cs.cmu.edu
#
# assumptions:
# - the container is xow collection widget,
# - all children in the collection form a forest,
# - each child belongs to exactly one tree in the collection.
# 
# procedures:
# tree.layout - find all roots and make (vertical or horizontal) layout,
#               in the case of vertical, trees will be layed verticaly in a row
#               in the case of horizontal, trees will be layed horizontaly in a
#               column,
# laytree.h   - make horizontal layout,
# laytree.v   - make vertical layout,
# tree.roots  - returns all tree roots in a collection.

proc tree.layout {coll {orientation vertical}} {
  set roots [tree.roots $coll]
  if {![llength $roots]} {return 0}
  unmap $coll
  set gap 20
  set start $gap
  if {[string compare $orientation vertical]} {
    foreach r $roots {
      set w [laytree.h $coll $r $gap $start]
      incr start $w
      incr start $gap
    }
  } else {
    foreach r $roots {
      set h [laytree.v $coll $r $start $gap]
      incr start $h
      incr start $gap
    }
  }
  map $coll
  return 1
}

proc laytree.v {coll root x y} {
  set vgap 20
  set hgap 20

  set name $coll.$root
  set subx $x
  set suby [expr $y+$vgap+[winfo height $name]]
  foreach sub [$coll from $root] {
    incr subx [expr $hgap+[laytree.v $coll $sub $subx $suby]]
  }
  set treew [expr $subx-$x-$hgap]
  set namew [winfo width $name]
  if {$namew>$treew} {set treew $namew}
  incr x [expr ($treew-$namew)/2]
  if {[winfo x $name]!=$x || [winfo y $name]!=$y} {move $name $x $y}
  return $treew
}

# because of the efficiency, these two functions (laytree.v & laytree.h) 
# were not merged into one

proc laytree.h {coll root x y} {
  set vgap 20
  set hgap 20

  set name $coll.$root
  set subx [expr $x+$hgap+[winfo width $name]]
  set suby $y
  foreach sub [$coll from $root] {
    incr suby [expr $vgap+[laytree.h $coll $sub $subx $suby]]
  }
  set treeh [expr $suby-$y-$vgap]
  set nameh [winfo height $name]
  if {$nameh>$treeh} {set treeh $nameh}
  incr y [expr ($treeh-$nameh)/2]
  if {[winfo x $name]!=$x || [winfo y $name]!=$y} {move $name $x $y}
  return $treeh
}

proc tree.roots {coll} {
  set rootno 0
  set roots {}
  set children [winfo children $coll]
  if {![llength $children]} {return {}}
  foreach c $children {
    set tono [llength [$coll to $c]]
    if {$tono == 0} {lappend roots [winfo name $c]}\
    else {if {$tono > 1} {error "not a tree (at $c)"}}
  }
  return $roots
}
