/* Bos_Objects.c - Built-in Bos Objects coded in C
 *
 * /afs/cs/project/edrc/ndim/source/bos/libbos/Bos_Objects.c,v 1.1.1.1 1992/05/08 19:45:32 snl Exp
 *
 * HISTORY
 *
 * Bos_Objects.c,v
 * Revision 1.1.1.1  1992/05/08  19:45:32  snl
 * bos 1.2
 *
 * Revision 1.1  92/03/06  22:02:57  snl
 * Initial revision
 * 
 * Revision 1.4  92/01/27  17:54:50  snl
 * n was not getting initialized in hashTable_print
 * 
 * Revision 1.3  92/01/27  16:19:24  snl
 * Port to new TCL
 * 
 * Revision 1.2  91/12/30  22:28:02  snl
 * Fixed bug in list_foreach; was returning error on zero-length list
 * 
 * Revision 1.1  91/12/16  20:14:43  snl
 * Initial revision
 * 
 */

#ifndef lint
static char *_RCSId =
 "/afs/cs/project/edrc/ndim/source/bos/libbos/Bos_Objects.c,v 1.1.1.1 1992/05/08 19:45:32 snl Exp";
#endif /* lint */

#include <stdio.h>
#include "bosInt.h"

#define defBuiltInMethod(pkg,name) \
static int pkg/**/_/**/name(cd, interp, argc, argv)\
Bos_CMethod_ClientData *cd;\
Tcl_Interp *interp;\
int argc;\
char **argv;\

#define declareBuiltInMethod(pkg,name) \
int pkg/**/_/**/name _ARGS_((Bos_CMethod_ClientData *cd,Tcl_Interp *interp,int argc,char **argv))

typedef struct _String_List {
  List_Links links;
  char *string;
} String_List;

Bos_Slot *_BosFindSlot _ARGS_((Bos_Object *obj,char *name));

int system_print();
int system_defMethod();
int system_copy();
int system__pointers();
int hashTable_put();
int hashTable_take();
int hashTable_lookup();
int hashTable_foreach();
int list_append();
int list_prepend();
int list_take();
int list_index();
int list_reorder();
int list_length();
int list_foreach();

_VoidPtr getContents();

void Bos_InitializeBuiltins()
{
  void createHooks(), createSubtypes();

  createHooks();
  createSubtypes();
}

void Bos_CreateBuiltinObjects(world, interp)
     Bos_World *world;
     Tcl_Interp *interp;
{
  void defMethod(), addSlot();
  Bos_Object *createObj(), *o;
  Bos_Slot_Subtype t;
  _VoidPtr hashTable_create(), list_create();

  o = createObj(world, interp, "SystemTraits");
  defMethod(o, "print", system_print);
  defMethod(o, "defMethod", system_defMethod);
  defMethod(o, "copy", system_copy);
  defMethod(o, "_pointers", system__pointers);

  o = createObj(world, interp, "System");
  addSlot(o, "systemParent", Bos_SLOT_OBJECT, 0, "SystemTraits");

  o = createObj(world, interp, "Object");
  addSlot(o, "systemParent", Bos_SLOT_OBJECT, 0, "SystemTraits");

  o = createObj(world, interp, "HashTableTraits");
  addSlot(o, "systemParent", Bos_SLOT_OBJECT, 0, "SystemTraits");
  defMethod(o, "put", hashTable_put);
  defMethod(o, "take", hashTable_take);
  defMethod(o, "lookup", hashTable_lookup);
  defMethod(o, "foreach", hashTable_foreach);

  t = Bos_GetCSlotType("hashTable");
  o = createObj(world, interp, "HashTable");
  addSlot(o, "hashTableParent", Bos_SLOT_OBJECT, 0, "HashTableTraits");
  addSlot(o, "contents", Bos_SLOT_FOREIGN, t, hashTable_create(0));

  o = createObj(world, interp, "ListTraits");
  addSlot(o, "systemParent", Bos_SLOT_OBJECT, 0, "SystemTraits");
  defMethod(o, "append", list_append);
  defMethod(o, "prepend", list_prepend);
  defMethod(o, "take", list_take);
  defMethod(o, "index", list_index);
  defMethod(o, "reorder", list_reorder);
  defMethod(o, "length", list_length);
  defMethod(o, "foreach", list_foreach);

  t = Bos_GetCSlotType("list");
  o = createObj(world, interp, "List");
  addSlot(o, "listParent", Bos_SLOT_OBJECT, 0, "ListTraits");
  addSlot(o, "contents", Bos_SLOT_FOREIGN, t, list_create());
}

static void createHooks()
{
  Bos_HookCMethod("system_print", system_print);
  Bos_HookCMethod("system_defMethod", system_defMethod);
  Bos_HookCMethod("system_copy", system_copy);
  Bos_HookCMethod("system__pointers", system__pointers);

  Bos_HookCMethod("hashTable_put", hashTable_put);
  Bos_HookCMethod("hashTable_take", hashTable_take);
  Bos_HookCMethod("hashTable_lookup", hashTable_lookup);
  Bos_HookCMethod("hashTable_foreach", hashTable_foreach);

  Bos_HookCMethod("list_append", list_append);
  Bos_HookCMethod("list_prepend", list_prepend);
  Bos_HookCMethod("list_take", list_take);
  Bos_HookCMethod("list_index", list_index);
  Bos_HookCMethod("list_reorder", list_reorder);
  Bos_HookCMethod("list_length", list_length);
  Bos_HookCMethod("list_foreach", list_foreach);
}

static void createSubtypes()
{
  char *hashTable_print();
  void hashTable_free();
  _VoidPtr hashTable_parse();
  _VoidPtr hashTable_copy();
  char *list_print();
  void list_free();
  _VoidPtr list_parse();
  _VoidPtr list_copy();

  if (Bos_DefineCSlotType("hashTable",
                           hashTable_print, 0,
			   hashTable_free, 0,
                           hashTable_parse, 0,
			   hashTable_copy, 0) == Bos_INVALID_SLOT_SUBTYPE)
    fprintf(stderr, "Bos/Tcl WARNING: could not create hashTable subtype\n");
  if (Bos_DefineCSlotType("list",
                          list_print, 0,
			  list_free, 0,
			  list_parse, 0,
			  list_copy, 0) == Bos_INVALID_SLOT_SUBTYPE)
    fprintf(stderr, "Bos/Tcl WARNING: could not create list subtype\n");
}

static Bos_Object *createObj(world, interp, name)
     Bos_World *world;
     Tcl_Interp *interp;
     char *name;
{
  Bos_Object *o;

  o = Bos_CreateNewObject(world, name);
  if (o != (Bos_Object *)0)
    Tcl_CreateCommand(interp, name, Bos_ObjectCmd, world, (void (*)())NULL);
  return o;
}

static void defMethod(obj, name, cmethod)
     Bos_Object *obj;
     char *name;
     int (*cmethod)();
{
  if (Bos_AddSlot(obj, name, Bos_SLOT_CMETHOD, 0, cmethod) != BOS_OK)
    fprintf(stderr, "Bos/Tcl WARNING: error adding cmethod %s to %s\n",
            name, obj->name);
}

static void addSlot(obj, name, type, pri, val)
     Bos_Object *obj;
     char *name;
     Bos_Slot_Type type;
     Bos_Slot_Pri pri;
     _VoidPtr val;
{
  if (Bos_AddSlot(obj, name, type, pri, val)  != BOS_OK)
    fprintf(stderr, "Bos/Tcl WARNING: error adding slot %s to %s (%d %d)\n",
            name, obj->name, type, pri);
}

static _VoidPtr getContents(interp, obj, slot_name, subtype_name)
     Tcl_Interp *interp;
     Bos_Object *obj;
     char *slot_name;
     char *subtype_name;
{
  _VoidPtr contents;
  Bos_Slot_Subtype t;
  Bos_Slot *slot;

  contents = (_VoidPtr)0;
  t = Bos_GetCSlotType(subtype_name);
  slot = _BosFindSlot(obj, slot_name);
  if (slot == (Bos_Slot *)0)
    sprintf(interp->result, "object \"%.50s\" has no %.50s slot",
            obj->name, slot_name);
  else if (slot->type != Bos_SLOT_FOREIGN)
    sprintf(interp->result, "object \"%.50s\" %s type is not foreign",
            obj->name, slot_name);
  else if (slot->pri != t)
    sprintf(interp->result, "object \"%.50s\" %s subtype is not %s",
            obj->name, subtype_name);
  else
    contents = slot->value;
  return contents;
}

/*
 * system builtin package
 */

defBuiltInMethod(system,print) {
  printf("#<Object %x>\n", cd->self);
  fflush(stdout);
  return BOS_OK;
}

defBuiltInMethod(system,defMethod) {
  int s;
  char *val;

  if (argc != 3) {
    sprintf(interp->result, "wrong # args to defMethod: need name, args, body");
    return BOS_ERROR;
  }
  if (_BosFindSlot(cd->self, argv[0]) != (Bos_Slot *)0) {
    if (Bos_RemoveSlot(cd->self, argv[0])  != BOS_OK) {
      sprintf(interp->result, "Bos error removing old slot %.50s from %.50s",
              argv[0], cd->self->name);
      return BOS_ERROR;
    }
  }
  val = Tcl_Merge(2, argv + 1);
  s = Bos_AddSlot(cd->self, argv[0], Bos_SLOT_METHOD, 0, (_VoidPtr)val);
  ckfree(val);
  if (s != BOS_OK)
    sprintf(interp->result, "Bos error adding method \"%.50s\" to \"%.50s\"",
            argv[0], cd->self->name);
  else
    s = BOS_OK;
  return s;
}

defBuiltInMethod(system,copy) {
  int s;

  if (argc != 1) {
    sprintf(interp->result, "wrong # args to copy: need newName");
    return BOS_ERROR;
  }
  if (Bos_Copy(cd->world, cd->self->name, argv[0]) == (Bos_Object *)0)
    s = BOS_ERROR;
  else {
    Tcl_CreateCommand(interp,argv[0],Bos_ObjectCmd,cd->world,(void (*)())NULL);
    s = BOS_OK;
  }
  return s;
}

defBuiltInMethod(system,_pointers) {
  Tcl_HashEntry *e;
  Tcl_HashSearch search;
  int s = BOS_OK;

  for (e = Tcl_FirstHashEntry(cd->self->slots, &search);
       e != (Tcl_HashEntry *)0;
       e = Tcl_NextHashEntry(&search)) {
    Bos_Slot *slot;

    slot = (Bos_Slot *)Tcl_GetHashValue(e);
    if (slot->type == Bos_SLOT_OBJECT)
      Tcl_AppendResult(interp, slot->name, " ", (char *)0);
  }
  return s;
}

/*
 * hashTable builtin package
 */

defBuiltInMethod(hashTable,put) {
  int s = BOS_OK;
  Tcl_HashTable *ht;

  if (argc != 2) {
    sprintf(interp->result, "wrong # args: need key, value");
    return BOS_ERROR;
  }
  ht = (Tcl_HashTable *)getContents(interp, cd->self, "contents", "hashTable");
  if (ht == (Tcl_HashTable *)0)
    s = BOS_ERROR;
  else {
    Tcl_HashEntry *entry;
    char *val;
    int new_p;

    entry = Tcl_CreateHashEntry(ht, argv[0], &new_p);
    if (!new_p)
      if (Tcl_GetHashValue(entry) != (ClientData)0)
        ckfree(Tcl_GetHashValue(entry));
    val = (char *)ckalloc(strlen(argv[1]) + 1);
    strcpy(val, argv[1]);
    Tcl_SetHashValue(entry, (ClientData)val);
    sprintf(interp->result, "%.50s", argv[0]);
  }
  return s;
}

defBuiltInMethod(hashTable,take) {
  int s = BOS_OK;
  Tcl_HashTable *ht;

  if (argc != 1) {
    sprintf(interp->result, "wrong # args: need key");
    return BOS_ERROR;
  }
  ht = (Tcl_HashTable *)getContents(interp, cd->self, "contents", "hashTable");
  if (ht == (Tcl_HashTable *)0)
    s = BOS_ERROR;
  else {
    Tcl_HashEntry *entry;

    entry = Tcl_FindHashEntry(ht, argv[0]);
    if (entry == (Tcl_HashEntry *)0) {
      sprintf(interp->result, "hashTable \"%.50s\" has no \"%.50s\" entry",
              cd->self->name, argv[0]);
      s = BOS_ERROR;
    } else {
      /*
       * Tcl will free the string after it is done with it.
       */
      interp->result = (char *)Tcl_GetHashValue(entry);
      interp->freeProc = TCL_DYNAMIC;
      Tcl_DeleteHashEntry(entry);
    }
  }
  return s;
}

defBuiltInMethod(hashTable,lookup) {
  int s = BOS_OK;
  Tcl_HashTable *ht;

  if (argc != 1) {
    sprintf(interp->result, "wrong # args: need key");
    return BOS_ERROR;
  }
  ht = (Tcl_HashTable *)getContents(interp, cd->self, "contents", "hashTable");
  if (ht == (Tcl_HashTable *)0)
    s = BOS_ERROR;
  else {
    Tcl_HashEntry *entry;

    entry = Tcl_FindHashEntry(ht, argv[0]);
    if (entry == (Tcl_HashEntry *)0)
      interp->result[0] = '\0';
    else
      interp->result = (char *)Tcl_GetHashValue(entry);
  }
  return s;
}

defBuiltInMethod(hashTable,foreach) {
  int s = BOS_OK;
  Tcl_HashTable *ht;

  if (argc != 2) {
    sprintf(interp->result, "wrong # args: need var body");
    return BOS_ERROR;
  }
  ht = (Tcl_HashTable *)getContents(interp, cd->self, "contents", "hashTable");
  if (ht == (Tcl_HashTable *)0)
    s = BOS_ERROR;
  else {
    Tcl_HashSearch search;
    Tcl_HashEntry *entry;
    char *buf;
#define DEFAULT_FOREACH_BUFLEN 128
    int buflen = DEFAULT_FOREACH_BUFLEN, result = TCL_OK;

    buf = (char *)ckalloc(DEFAULT_FOREACH_BUFLEN+1);
    for (entry = Tcl_FirstHashEntry(ht, &search);
	 entry != (Tcl_HashEntry *)0;
	 entry = Tcl_NextHashEntry(&search)) {
      char *val, *key;

      val = (char *)Tcl_GetHashValue(entry);
      key = (char *)Tcl_GetHashKey(ht, entry);
      if ((strlen(val) + strlen(key) + 3) >= buflen) {
	buflen = strlen(val) + strlen(key) + 3 + 25;
#ifdef TCL_MEM_DEBUG
	ckfree(buf);
	buf = (char *)ckalloc(buflen+1);
#else
	buf = (char *)realloc(buf, buflen+1);
#endif /* TCL_MEM_DEBUG */
      }
      sprintf(buf, "{%s %s}", key, val);
      Tcl_SetVar(interp, argv[0], buf, 0);
      result = Tcl_Eval(interp, argv[1], 0, (char **)NULL);
      if (result != TCL_OK) {
	if (result == TCL_CONTINUE) {
	  result = TCL_OK;
	} else if (result == TCL_BREAK) {
	  result = TCL_OK;
	  break;
	} else if (result == TCL_ERROR) {
	  char msg[100];

	  sprintf(msg, " (\"hashTable_foreach\" body line %d)",
		  interp->errorLine);
	  Tcl_AddErrorInfo(Bos_Methods(cd->world), interp, msg);
	  break;
	} else {
	  break;
	}
      }
    }
    ckfree(buf);
    if (result != TCL_OK)
      s = BOS_ERROR;
    else {
      Tcl_Return(interp, (char *)NULL, TCL_STATIC);
      s = BOS_OK;
    }
  }
  return s;
}

static _VoidPtr hashTable_create(size)
     int size;
{
  Tcl_HashTable *ht;

  ht = (Tcl_HashTable *)ckalloc(sizeof(Tcl_HashTable));
  Tcl_InitHashTable(ht, TCL_STRING_KEYS);
  return (_VoidPtr)ht;
}

static char *hashTable_print(value, arg, subtype)
     _VoidPtr value;
     _VoidPtr arg;
     Bos_Slot_Subtype subtype;
{
  Tcl_HashTable *ht = (Tcl_HashTable *)value;
  Tcl_HashEntry *entry;
  Tcl_HashSearch search;
  int total_len = 0, n = 0;
  char *buf;

  for (entry = Tcl_FirstHashEntry(ht, &search);
       entry != (Tcl_HashEntry *)0;
       entry = Tcl_NextHashEntry(&search))
    if (Tcl_GetHashValue(entry) != (ClientData)0) {
      total_len += strlen((char *)Tcl_GetHashValue(entry)) +
                    strlen(Tcl_GetHashKey(ht, entry)) + 4;
      n++;
    }
  if (!total_len)
    total_len = 1;
  buf = (char *)ckalloc(total_len);
  *buf = '\0';
  for (entry = Tcl_FirstHashEntry(ht, &search);
       entry != (Tcl_HashEntry *)0;
       entry = Tcl_NextHashEntry(&search))
    if (Tcl_GetHashValue(entry) != (ClientData)0) {
      strcat(buf, "{");
      strcat(buf, Tcl_GetHashKey(ht, entry));
      strcat(buf, " ");
      strcat(buf, (char *)Tcl_GetHashValue(entry));
      strcat(buf, "}");
      if (--n > 0)
        strcat(buf, " ");
    }
  return buf;
}

static _VoidPtr hashTable_parse(string, arg, subtype)
     char *string;
     _VoidPtr arg;
     Bos_Slot_Subtype subtype;
{
  Tcl_Interp *dummy;
  int nelts, e;
  char **elts;
  Tcl_HashTable *ht;
  _VoidPtr hashTable_create();

  dummy = Tcl_CreateInterp();
  if (Tcl_SplitList(dummy, string, &nelts, &elts) != TCL_OK) {
    fprintf(stderr, "Bos/Tcl WARNING: hashTable_parse(%s) split error: %s\n",
            string, dummy->result);
    Tcl_DeleteInterp(dummy);
    return (_VoidPtr)0;
  }
  ht = (Tcl_HashTable *)hashTable_create(nelts);
  for (e = 0; e < nelts; e++) {
    int nss;
    char **ss;

    if (Tcl_SplitList(dummy, elts[e], &nss, &ss) != TCL_OK)
      fprintf(stderr, "Bos/Tcl WARNING: hashTable_parse(%s) split error: %s\n",
              elts[e], dummy->result);
    else if (nss != 2) {
      fprintf(stderr, "Bos/Tcl WARNING: hashTable_parse(%s) badly formed elt\n",
              elts[e]);
      ckfree(ss);
    } else {
      char *val;
      Tcl_HashEntry *entry;
      int new_p;

      val = (char *)ckalloc(strlen(ss[1]) + 1);
      strcpy(val, ss[1]);
      entry = Tcl_CreateHashEntry(ht, ss[0], &new_p);
      if (!new_p) {
        if (Tcl_GetHashValue(entry) != (ClientData)0)
	  ckfree(Tcl_GetHashValue(entry));
      }
      Tcl_SetHashValue(entry, (ClientData)val);
      ckfree(ss);
    }
  }
  if (elts != (char **)0)
    ckfree(elts);
  Tcl_DeleteInterp(dummy);
  return (_VoidPtr)ht;
}

static void hashTable_free(value, arg, subtype)
     _VoidPtr value;
     _VoidPtr arg;
     Bos_Slot_Subtype subtype;
{
  Tcl_HashTable *ht = (Tcl_HashTable *)value;
  Tcl_HashEntry *entry;
  Tcl_HashSearch search;

  for (entry = Tcl_FirstHashEntry(ht, &search);
       entry != (Tcl_HashEntry *)0;
       entry = Tcl_NextHashEntry(&search)) {
    if (Tcl_GetHashValue(entry) != (ClientData)0)
      ckfree(Tcl_GetHashValue(entry));
    Tcl_DeleteHashEntry(entry);
  }
  Tcl_DeleteHashTable(ht);
  ckfree(ht);
}

static _VoidPtr hashTable_copy(value, arg, subtype)
     _VoidPtr value;
     _VoidPtr arg;
     Bos_Slot_Subtype subtype;
{
  Tcl_HashTable *ht = (Tcl_HashTable *)value, *ht_copy;
  Tcl_HashEntry *entry;
  Tcl_HashSearch search;
  _VoidPtr hashTable_create();

  ht_copy = (Tcl_HashTable *)hashTable_create(0);
  for (entry = Tcl_FirstHashEntry(ht, &search);
       entry != (Tcl_HashEntry *)0;
       entry = Tcl_NextHashEntry(&search)) {
    char *val, *key;
    Tcl_HashEntry *entry_copy;
    int new_p;	/* XXX ignored */

    val = (char *)Tcl_GetHashValue(entry);
    key = Tcl_GetHashKey(ht, entry);
    entry_copy = Tcl_CreateHashEntry(ht_copy, key, &new_p);
    Tcl_SetHashValue(entry_copy, (ClientData)0);
    if (val != (char *)0) {
      char *copy;

      copy = (char *)ckalloc(strlen(val) + 1);
      strcpy(copy, val);
      Tcl_SetHashValue(entry_copy, (ClientData)copy);
    }
  }
  return (_VoidPtr)ht_copy;
}

/*
 * lists
 */

defBuiltInMethod(list,append) {
  String_List *list;
  int s;

  if (argc < 1) {
    sprintf(interp->result, "wrong # args: need at least one thing to put");
    return BOS_ERROR;
  }
  list = (String_List *)getContents(interp, cd->self, "contents", "list");
  if (list == (String_List *)0)
    s = BOS_ERROR;
  else {
    List_Links *the_list = (List_Links *)list;
    int a;

    for (a = 0; a < argc; a++) {
      String_List *item;

      item = (String_List *)ckalloc(sizeof(String_List));
      List_InitElement((List_Links *)item);
      item->string = (char *)ckalloc(strlen(argv[a]) + 1);
      strcpy(item->string, argv[a]);
      List_Insert((List_Links *)item, LIST_ATREAR(the_list));
    }
    s = BOS_OK;
  }
  return s;
}

defBuiltInMethod(list,prepend) {
  String_List *list;
  int s;

  if (argc < 1) {
    sprintf(interp->result, "wrong # args: need at least one thing to put");
    return BOS_ERROR;
  }
  list = (String_List *)getContents(interp, cd->self, "contents", "list");
  if (list == (String_List *)0)
    s = BOS_ERROR;
  else {
    List_Links *the_list = (List_Links *)list;
    int a;

    for (a = 0; a < argc; a++) {
      String_List *item;

      item = (String_List *)ckalloc(sizeof(String_List));
      List_InitElement((List_Links *)item);
      item->string = (char *)ckalloc(strlen(argv[a]) + 1);
      strcpy(item->string, argv[a]);
      List_Insert((List_Links *)item, LIST_ATFRONT(the_list));
    }
    s = BOS_OK;
  }
  return s;
}

defBuiltInMethod(list,take) {
  String_List *list;
  int s, idx;

  if (argc != 1) {
    sprintf(interp->result, "wrong # args: need index of item to take");
    return BOS_ERROR;
  } else if (sscanf(argv[0], "%d", &idx) != 1) {
    sprintf(interp->result, "arg %.50s did not scan as integer", argv[0]);
    return BOS_ERROR;
  }
  list = (String_List *)getContents(interp, cd->self, "contents", "list");
  if (list == (String_List *)0)
    s = BOS_ERROR;
  else {
    List_Links *the_list = (List_Links *)list, *the_item;
    String_List *item = (String_List *)0;
    int i;

    i = 0;
    LIST_FORALL(the_list,the_item) {
      if (i == idx) {
        item = (String_List *)the_item;
	break;
      } else
        i++;
    }
    if (item != (String_List *)0) {
      interp->result = item->string;
      interp->freeProc = TCL_DYNAMIC;
      List_Remove(the_item);
      s = BOS_OK;
    } else {
      sprintf(interp->result, "index %d not valid", idx);
      s = BOS_ERROR;
    }
  }
  return s;
}

defBuiltInMethod(list,index) {
  String_List *list;
  int s;

  if (argc != 1) {
    sprintf(interp->result, "wrong # args: need string");
    return BOS_ERROR;
  }
  list = (String_List *)getContents(interp, cd->self, "contents", "list");
  if (list == (String_List *)0)
    s = BOS_ERROR;
  else {
    List_Links *the_list = (List_Links *)list, *the_item;
    int found = 0, i = 0;

    LIST_FORALL(the_list,the_item) {
      String_List *item = (String_List *)the_item;

      if (!strcmp(item->string, argv[0])) {
        found = 1;
	break;
      } else
        i++;
    }
    sprintf(interp->result, "%d", found? i: -1);
    s = BOS_OK;
  }
  return s;
}

defBuiltInMethod(list,reorder) {
  int s = BOS_OK;
  List_Links *list;

  if (argc < 3 || (argc % 3) != 0) {
    sprintf(interp->result, "wrong # args: need idx op idx ...");
    return BOS_ERROR;
  }
  list = (List_Links *)getContents(interp, cd->self, "contents", "list");
  if (list == (List_Links *)0)
    return BOS_ERROR;
  while (argc > 0) {
    int src, dst;
    char *op;
    List_Links *src_elt, *dst_elt, *list_getIdx();

    if (sscanf(*argv++, "%d", &src) != 1) {
      sprintf(interp->result, "src index did not scan: %.50s", *--argv);
      s = BOS_ERROR;
      break;
    } else if ((src_elt = list_getIdx(list, src)) == (List_Links *)0) {
      sprintf(interp->result, "src index %d out of bounds", src);
      s = BOS_ERROR;
      break;
    }
    op = *argv++;
    if (sscanf(*argv++, "%d", &dst) != 1) {
      sprintf(interp->result, "dst index did not scan: %.50s", *--argv);
      s = BOS_ERROR;
      break;
    } else if ((dst_elt = list_getIdx(list, dst)) == (List_Links *)0) {
      sprintf(interp->result, "dst index %d out of bounds", dst);
      s = BOS_ERROR;
      break;
    }
    argc -= 3;
    if (!strcmp(op, "before")) {
      List_Remove(src_elt);
      List_Insert(src_elt, LIST_BEFORE(dst_elt));
    } else if (!strcmp(op, "after")) {
      List_Remove(src_elt);
      List_Insert(src_elt, LIST_AFTER(dst_elt));
    } else {
      sprintf(interp->result, "unknown reorder op: %.50s", op);
      s = BOS_ERROR;
      break;
    }
  }
  return s;
}

defBuiltInMethod(list,length) {
  List_Links *list;

  list = (List_Links *)getContents(interp, cd->self, "contents", "list");
  if (list == (List_Links *)0)
    return BOS_ERROR;
  else {
    int length = 0;
    List_Links *elt;

    LIST_FORALL(list,elt) {
      length++;
    }
    sprintf(interp->result, "%d", length);
  }
  return BOS_OK;
}

defBuiltInMethod(list,foreach) {
  int s = BOS_OK;
  List_Links *list;

  if (argc != 2) {
    strcpy(interp->result, "wrong # args: need var body");
    return BOS_ERROR;
  }
  list = (List_Links *)getContents(interp, cd->self, "contents", "list");
  if (list == (List_Links *)0)
    s = BOS_ERROR;
  else {
    List_Links *elt;
    int result = TCL_OK;

    LIST_FORALL(list,elt) {
      String_List *string = (String_List *)elt;

      Tcl_SetVar(interp, argv[0], string->string, 0);
      result = Tcl_Eval(interp, argv[1], 0, (char **)NULL);
      if (result != TCL_OK) {
	if (result == TCL_CONTINUE) {
	  result = TCL_OK;
	} else if (result == TCL_BREAK) {
	  result = TCL_OK;
	  break;
	} else if (result == TCL_ERROR) {
	  char msg[100];

	  sprintf(msg, " (\"list_foreach\" body line %d)",
		  interp->errorLine);
	  Tcl_AddErrorInfo(interp, msg);
	  break;
	} else {
	  break;
	}
      }
    }
    if (result != TCL_OK)
      s = BOS_ERROR;
    else {
      s = BOS_OK;
      Tcl_Return(interp, (char *) NULL, TCL_STATIC);
    }
  }
  return s;
}
static List_Links *list_getIdx(list, idx)
     List_Links *list;
     int idx;
{
  List_Links *elt;

  LIST_FORALL(list,elt) {
    if (!idx)
      break;
    else
      idx--;
  }
  return (!idx)? elt: (List_Links *)0;
}

static _VoidPtr list_create() {
  String_List *list;

  list = (String_List *)ckalloc(sizeof(String_List));
  List_Init((List_Links *)list);
  list->string = (char *)0;
  return (_VoidPtr)list;
}

static char *list_print(value, arg, subtype)
     _VoidPtr value;
     _VoidPtr arg;
     Bos_Slot_Subtype subtype;
{
  List_Links *list = (List_Links *)value, *item;
  int total_len = 0, n = 0;
  char *buf;

  LIST_FORALL(list,item) {
    String_List *entry = (String_List *)item;

    if (entry->string != (char *)0) {
      total_len += strlen(entry->string) + 1;
      n++;
    }
  }
  if (!total_len)
    total_len = 1;
  buf = (char *)ckalloc(total_len);
  *buf = '\0';
  LIST_FORALL(list,item) {
    String_List *entry = (String_List *)item;

    if (entry->string != (char *)0) {
      strcat(buf, entry->string);
      if (--n > 0)
        strcat(buf, " ");
    }
  }
  return buf;
}

static _VoidPtr list_parse(string, arg, subtype)
     char *string;
     _VoidPtr arg;
     Bos_Slot_Subtype subtype;
{
  Tcl_Interp *dummy;
  char **argv = (char **)0;
  int argc;
  List_Links *the_list;

  dummy = Tcl_CreateInterp();
  if (Tcl_SplitList(dummy, string, &argc, &argv) != TCL_OK) {
    fprintf(stderr, "Bos/Tcl WARNING: list_parse(%s) split error: %s\n",
            string, dummy->result);
    Tcl_DeleteInterp(dummy);
    return (_VoidPtr)0;
  } else {
    int a;

    the_list = (List_Links *)list_create();
    for (a = 0; a < argc; a++) {
      String_List *item;

      item = (String_List *)ckalloc(sizeof(String_List));
      List_InitElement((List_Links *)item);
      item->string = (char *)ckalloc(strlen(argv[a]) + 1);
      strcpy(item->string, argv[a]);
      List_Insert((List_Links *)item, LIST_ATREAR(the_list));
    }
  }
  if (argv != (char **)0)
    ckfree(argv);
  Tcl_DeleteInterp(dummy);
  return (_VoidPtr)the_list;
}

static void list_free(value, arg, subtype)
     _VoidPtr value;
     _VoidPtr arg;
     Bos_Slot_Subtype subtype;
{
  List_Links *list = (List_Links *)value, *entry;

  LIST_FORALL(list,entry) {
    String_List *item = (String_List *)entry;

    List_Remove(entry);
    ckfree(item->string);
  }
  ckfree(list);
}

static _VoidPtr list_copy(value, arg, subtype)
     _VoidPtr value;
     _VoidPtr arg;
     Bos_Slot_Subtype subtype;
{
  List_Links *new_list, *entry, *list = (List_Links *)value;

  new_list = (List_Links *)list_create();
  LIST_FORALL(list,entry) {
    String_List *item = (String_List *)entry, *new_item;

    new_item = (String_List *)ckalloc(sizeof(String_List));
    new_item->string = (char *)ckalloc(strlen(item->string) + 1);
    strcpy(new_item->string, item->string);
    List_Insert((List_Links *)new_item, LIST_ATREAR(new_list));
  }
  return (_VoidPtr)new_list;
}
