/* bosSearch.h - semi-exported in-core search facility */

/* Copyright (c) 1992 Engineering Design Resarch Center
 */

#ifndef __bosSearch_H__
#define __bosSearch_H__

#include "bosMacros.h"
#include <tclHash.h>

typedef short Bos_Search_Boolean;	/* Search Boolean Operator */

#define Bos_SEARCH_STRING_EQ 1
#define Bos_SEARCH_STRING_NE 2
#define Bos_SEARCH_STRING_GT 3
#define Bos_SEARCH_STRING_LT 4
#define Bos_SEARCH_STRING_GE 5
#define Bos_SEARCH_STRING_LE 6
#define Bos_SEARCH_INT_EQ 7
#define Bos_SEARCH_INT_NE 8
#define Bos_SEARCH_INT_GT 9
#define Bos_SEARCH_INT_LT 10
#define Bos_SEARCH_INT_GE 11
#define Bos_SEARCH_INT_LE 12
#define Bos_SEARCH_TYPE_EQ 13
#define Bos_SEARCH_TYPE_NE 14

#define Bos_SEARCH_ILLEGAL 0

Tcl_HashTable *
Bos_Search1 _ARGS_((
	Tcl_HashTable *search_space,
	Tcl_HashTable *results,
	char *slot_name,
	Bos_Search_Boolean boolean,
	char *value
));

void
Bos_DestroySearchResults _ARGS_((
	Tcl_HashTable *table
));

#endif /* __bosSearch_H__ */
