/*
 *-----------------------------------------------------------------------------
 *  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the "Terms and Conditions of Distribution", given in the documentation
 *  to this software, are applicable and the above copyright message appears
 *  in each copy.
 *
 *-----------------------------------------------------------------------------
 *
 *
 *  This file contains the application specific Tcl commands for the sample
 *  application for demonstrating the use of the CTAXT interface
 *
 *  13.12.1993   hp      1st version
 */


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/TextF.h>
#include "ctaxt.h"




/*
 *  function prototypes
 */

int yesNoBox _ANSI_ARGS_((Tcl_Interp *interp));




/*
 *  reportCoords ---
 *
 *  This function implements the Tcl command to report coordinates
 *  in a textfield widget. See the Tcl/Tk documentation for details on
 *  the function's arguments.
 *
 *  Result: 
 *
 *    a standard Tcl result
 *
 *  Side effects:
 *
 *    The entry in the textfield will get updatet
 */

int 
reportCoords (clientData,interp,argc,argv)
  ClientData clientData;
  Tcl_Interp *interp;
  int argc;
  char *argv[];
{
  Widget *entry = (Widget *) clientData;


  /*  first of all, check the arguments  */

  if(argc != 3) {
    Tcl_AppendResult (interp,
		      "wrong # of args, should be: \"",
		      argv[0],
		      " x y\"",
		      NULL);
    return TCL_ERROR;
  }

  /*  form the output string by concatenating the coordinates comma
      seperated. Use the interpreter for string creation  */

  Tcl_AppendResult (interp,
		    argv[1],
		    ", ",
		    argv[2],
		    NULL); 

  /*  display the coordinates in the text field  */

  XmTextFieldSetString (*entry,interp->result);

  /*  reset the interpreter, otherwise Tcl would report an error  */

  Tcl_ResetResult(interp);
  return TCL_OK;
}


/*
 *  handleTkBackgroundError ---
 *
 *  This function implements the Tcl command to handle background errors for
 *  Tk. It will ask the user, whether or not the error should be corrected.
 *
 *  Result: 
 *
 *    a standard Tcl result
 *
 *  Side effects:
 *
 *    The binding for the rectangle might be corrected
 */

int 
handleTkBackgroundError (clientData,interp,argc,argv)
  ClientData clientData;
  Tcl_Interp *interp;
  int argc;
  char *argv[];
{
  /*  first of all, check the arguments  */

  if(argc != 2) {
    Tcl_AppendResult (interp,
		      "wrong # of args, should be: \"",
		      argv[0],
		      " errorMessage\"",
		      NULL);
    return TCL_ERROR;
  }

  /*  produce the message for the yes/no-box  */

  Tcl_AppendResult (interp,
		    "Tk detected an background error: \n\n\"",
		    argv[1],
		    "\".\n\n"
		    "If the application should fix it, hit the \"Yes\"-button",
		    ",\notherwise the \"No\"-button.",
		    NULL);
  yesNoBox (interp);

  /*  reset the interpreter, otherwise Tcl would report an error  */

  Tcl_ResetResult(interp);
  return TCL_OK;
}
