/*
 *  -----------------------------------------------------------------
 *    Copyright 1993 D.I.S. - Universita` di Pavia - Italy
 *  -----------------------------------------------------------------
 *
 *  Permission to  use,  copy,   modify,   distribute  this  software
 *  and  its  documentation for any purpose is hereby granted without
 *  fee, provided that the above copyright  notice   appear   in  all
 *  copies   and  that both that copyright notice and this permission
 *  notice appear in supporting documentation, and that the  name  of
 *  D.I.S.   not  be  used  in advertising or publicity pertaining to
 *  distribution of the software without specific, written prior per-
 *  mission.   D.I.S.  makes no representations about the suitability
 *  of this software for any purpose.  It is provided "as is" without
 *  express or implied warranty.
 *
 *  D.I.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, IN-
 *  CLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 *  NO EVENT SHALL D.I.S.  BE LIABLE FOR  ANY  SPECIAL,  INDIRECT  OR
 *  CONSEQUENTIAL  DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING FROM
 *  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
 *  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNEC-
 *  TION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Small changes made to fit my package's setup.
 * Michael Moore (mdm@cis.ohio-state.edu)
 * December 24th, 1993
 */


#include <tcl.h>
#include <dlfcn.h>


int dl_load(Tcl_Interp *interp, char *path, char *initFun)
{
    void *xlib;
    int (*install)(Tcl_Interp *);

	/*
	 *	If the named library does not exist, if it's not loadable or if
	 *	it does not define the named install proc, report an error
	 */
    if ( (xlib=dlopen(path, 1)) == NULL 
            ||(install=(int (*)(Tcl_Interp *))dlsym(xlib, initFun)) == NULL ) {
        Tcl_SetResult(interp, dlerror(), TCL_VOLATILE);
        if ( xlib != NULL ) dlclose(xlib);
        return TCL_ERROR;
    }

	/*	
	 *	Try to install the exstension and report success or failure
	 */
    return (*install)(interp);
}

