/* compat.c
***************************************************************************** 
expecTerm version 1.0 beta
Mark Weissman
Christopher Matheus
Copyright 1992 by GTE Laboratories Incorporated.

Portions of this work are in the public domain.  Permission to use,
copy, modify, and distribute this software and its documentation for
any purpose and without fee is hereby granted, provided that the above
copyright notice appear in all copies and that both the copyright
notice and warranty disclaimer appear in supporting documentation, and
that the names of GTE Laboratories or any of their entities not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

GTE disclaims all warranties with regard to this software, including
all implied warranties of merchantability and fitness for a particular
purpose, even if GTE Laboratories Incorporated knows about the
purpose.  In no event shall GTE be liable for any special, indirect or
consequential damages or any damages whatsoever resulting from loss of
use, data or profits, whether in an action of contract, negligence or
other tortuous action, arising out of or in connection with the use or
performance of this software.

This code is based on and may include parts of Don Libes' expect code:
  expect written by: Don Libes, NIST, 2/6/90
  Design and implementation of expect was paid for by U.S. tax
  dollars.  Therefore it is public domain.  However, the author and NIST
  would appreciate credit if this program or parts of it are used.

******************************************************************************/

#ifndef COMPAT_INCLUDED

#ifdef _AIX
#include <sys/limits.h>
#include <sys/select.h>
#include <sys/mode.h>
#include <sys/ioctl.h>
#include <curses.h>
#include <termio.h>
#define FALSE 0
#define TRUE 1
#define curs_set(X) NULL
typedef struct term TERMINAL;
#define set_curterm(NEW) (cur_term = NEW)
#define keypad(WIN, FLAG) ((WIN)->_use_keypad=FLAG)
#define meta(WIN, FLAG) ((WIN)->_use_meta=FLAG)
#endif

#ifdef _DEC
#include <termios.h>
#include <sys/limits.h>
#include <cursesX.h>
#include <sys/ioctl.h>
#define curs_set(X) NULL
#define ualarm(X,Y) Ualarm(X,Y) /* for machines w/o ualarm() */
#define TERMINAL struct term
#define SV_RESETHAND     0x0004
#define set_curterm(NEW) (cur_term = NEW)
#endif

#ifdef _SUN
#include <sys/limits.h>
#include <curses.h>
#include <termio.h>
#define WORD_BIT 32
#define OPEN_MAX 32
#endif

#ifdef _HP
#include <curses.h>
#include <termio.h>
#define ualarm(X,Y) Ualarm(X,Y) /* for machines w/o ualarm() */
#define TERMINAL struct term
#define curs_set(X) NULL
#endif

#define COMPAT_INCLUDED 1
#endif /* COMPAT_INCLUDED */

