/* expTerm.c
***************************************************************************** 
expecTerm version 1.0 beta
Mark Weissman
Christopher Matheus
Copyright 1992 by GTE Laboratories Incorporated.

Portions of this work are in the public domain.  Permission to use,
copy, modify, and distribute this software and its documentation for
any purpose and without fee is hereby granted, provided that the above
copyright notice appear in all copies and that both the copyright
notice and warranty disclaimer appear in supporting documentation, and
that the names of GTE Laboratories or any of their entities not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

GTE disclaims all warranties with regard to this software, including
all implied warranties of merchantability and fitness for a particular
purpose, even if GTE Laboratories Incorporated knows about the
purpose.  In no event shall GTE be liable for any special, indirect or
consequential damages or any damages whatsoever resulting from loss of
use, data or profits, whether in an action of contract, negligence or
other tortuous action, arising out of or in connection with the use or
performance of this software.

This code is based on and may include parts of Don Libes' expect code:
  expect written by: Don Libes, NIST, 2/6/90
  Design and implementation of expect was paid for by U.S. tax
  dollars.  Therefore it is public domain.  However, the author and NIST
  would appreciate credit if this program or parts of it are used.

******************************************************************************/

#include "win.h"
#include "translate.h"
#include "global.h"
#include <errno.h>

/* #define USE_PAD */
#ifdef USE_PAD
#define NEWWIN(SROWS, SCOLS, PROWS, PCOLS) \
  (struct _win_st *)newpad(PROWS,PCOLS)
#define REFRESH(WIN, PMINROW, PMINCOL, SMINROW, SMINCOL, SMAXROW, SMAXCOL) \
  prefresh(WIN, PMINROW, PMINCOL, SMINROW, SMINCOL, SMAXROW, SMAXCOL)
#else
#define NEWWIN(SROWS, SCOLS, PROWS, PCOLS) \
  (struct _win_st *)newwin(SROWS,SCOLS,0,0)
#define REFRESH(WIN, PMINROW, PMINCOL, SMINROW, SMINCOL, SMAXROW, SMAXCOL) \
  wrefresh(WIN)
#endif

long ChildDiedP=0;
char Buffer[BUFSIZ];
char *indent="";
long InitScr = 0;
/* #define DEBUG_EOF 1 */
char in_curses = 0;
static char was_in_curses_stack[64], *was_in_curses = was_in_curses_stack;

#define USE_SHELL_MODE

#ifdef USE_SHELL_MODE
#define DefShellMode() def_shell_mode()
#define DefProgMode()  def_prog_mode()
#define ResetProgMode() reset_prog_mode()
#define ResetShellMode() reset_shell_mode()
#else
static struct termios shell_termios, curses_termios;
#define DefShellMode() tcgetattr(0,&shell_termios)
#define DefProgMode()  tcgetattr(0,&curses_termios)
#define ResetProgMode() tcsetattr(0,TCSANOW,&curses_termios)
#define ResetShellMode() tcsetattr(0,TCSANOW,&shell_termios)
#endif

PushCursesMode() {
  *was_in_curses = in_curses;
  if (!*was_in_curses) {
    DefShellMode();
    if (InitScr) {
      ResetProgMode();
    }
    in_curses='c';
  }
  ++was_in_curses;
}

PushShellMode () {
  *was_in_curses = in_curses;
  if (*was_in_curses) {
    if (InitScr) {
      DefProgMode();
    }
    ResetShellMode();
    in_curses='\0';
  }
  ++was_in_curses;
}

PopCursesMode() {
  --was_in_curses;
  if (!*was_in_curses) {
    if (InitScr) {
      DefProgMode();
    }
    ResetShellMode();
    in_curses='\0';
  }
}

PopShellMode() {
  --was_in_curses;
  if (*was_in_curses) {
    DefShellMode();
    if (InitScr) {
      ResetProgMode();
    }
    in_curses='y';
  }
}

#define WITH_CURSES(BODY) {\
  PushCursesMode(); \
  BODY; \
  PopCursesMode(); \
}

#define WITHOUT_CURSES(BODY) {\
  PushShellMode(); \
  BODY; \
  PopShellMode(); \
}

InitializeCurses() {
  struct winsize ws;
  ioctl(0, TIOCGWINSZ, &ws);
  ioctl(0, TIOCSWINSZ, &ws);
  WITH_CURSES({
    if (!InitScr) {
      initscr(); /* TermScreen = newterm("xterm",inp,outp); set_term(TermScreen); */
      DefProgMode();
      InitScr = 1;
      scrollok(stdscr,FALSE);
    }});
}

#include <varargs.h>
int
  FuncallWithoutCurses(va_alist) 
va_dcl
{
  va_list ap;
  IFPTR func;
  int result;
  void *argv[16];
  int argc, i;
  char *fatalmess = NULL;
  va_start(ap);
  func = va_arg(ap, IFPTR);
  argc = (int) va_arg(ap, int);
  for (i=0; i< argc; ++i) argv[i] = (void *) va_arg(ap, void *);
  va_end(ap);
  WITHOUT_CURSES({
    switch (argc) {
    case 0:  result = (*func)(); break;
    case 1:  result = (*func)(argv[0]); break;
    case 2:  result = (*func)(argv[0], argv[1]); break;
    case 3:  result = (*func)(argv[0], argv[1], argv[2]); break;
    case 4:  result = (*func)(argv[0], argv[1], argv[2], argv[3]); break;
    case 5:  result = (*func)(argv[0], argv[1], argv[2], argv[3], argv[4]); break;
    case 6:  result = (*func)(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5]); break;
    case 7:  result = (*func)(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5], argv[6]); break;
    case 8:  result = (*func)(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7]); break;
    case 9:  result = (*func)(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7], argv[8]); break;
    case 10: result = (*func)(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7], argv[8], argv[9]); break;
    case 11: result = (*func)(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7], argv[8], argv[9], argv[10]); break;
    case 12: result = (*func)(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7], argv[8], argv[9], argv[10], argv[11]); break;
    case 13: result = (*func)(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7], argv[8], argv[9], argv[10], argv[11], argv[12]); break;
    case 14: result = (*func)(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7], argv[8], argv[9], argv[10], argv[11], argv[12], argv[13]); break;
    case 15: result = (*func)(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7], argv[8], argv[9], argv[10], argv[11], argv[12], argv[13], argv[14]); break;
    case 16: result = (*func)(argv[0], argv[1], argv[2], argv[3], argv[4], argv[5], argv[6], argv[7], argv[8], argv[9], argv[10], argv[11], argv[12], argv[13], argv[14], argv[15]); break;
    default: fatalmess = "Illegal Number of args to FuncallWithoutCurses";
    }});
  if (fatalmess) { fatal(fatalmess); exit(-1); }
  return(result);
}

SESSION *Session, *CurrSession;
SESSION *Sessions[WIN_SESSION_MAX];
long MaxSession=0;
long WinbarP=1;
long Rows= 24;
long Columns= 80;

ToggleWinbarP() { WinbarP = !WinbarP; }

SetCurrSession() {
  CurrSession=Session;
}

SetSessionFromFD(fd)
int fd;
{
  Session = Sessions[fd];
  return(Session?1:0);
}

SessionBufferedInputP()
{
  return(Session && Session->input_cached_p);
}

ResetWindow()
{
  WITH_CURSES({
    clear();
    if (loguser) refresh();
    if (CurrSession) touchwin(CurrSession->win);
    SetStatusLine(NULL);
    winbar(1);});
}

UpdateWindow(message) 
char *message;
{
  SetStatusLine(message);
  if (!SessionBufferedInputP()) WITH_CURSES(winbar((message && 1)));
}

long CreateSession(num, Rows, Columns, MaxRow, MaxCol)
int Rows, Columns, num, MaxRow, MaxCol;
{
  CurrSession = Session = Sessions[num] = (SESSION *)calloc(1,sizeof(SESSION));
  Session->num = MaxSession;
  ++MaxSession;
  Session->rows = Rows; /* Should come from emulated lines */
  Session->columns = Columns; /* Should come from emulated columns */
  Session->lmarg = 0;
  Session->rmarg = Session->columns;

  Session->pad.maxrow = (MaxRow > Rows) ? MaxRow : Rows;
  Session->pad.minrow = Session->pad.mincol = 0L;
  Session->pad.maxcol = Session->columns;

  Session->win = NEWWIN(Session->rows, Session->columns, Session->pad.maxrow,Session->pad.maxcol);

  Session->echop = atoi(get_var("term_echo")); /* CJM added get_var */
  Session->crnlp = atoi(get_var("term_crnl")); /* CJM added get_var */
  Session->breaksp = atoi(get_var("term_breaks")); /* MDW added get_var */
  Session->tabspacep = atoi(get_var("term_tabspace")); /* CJM added get_var */
  Session->rawBuff = (char *)malloc((Session->rawMax=WIN_RAW_MAX)+2);
  Session->rawBuff[Session->rawIndex=0] = '\0';
  Session->cookedIndex=0;
  Session->term=NULL;
  Session->expIndex = Session->rawEnd = Session->rawIndex = 0;
  if (!Session->win) { fatal("window creation error"); exit(-1); }
  scrollok(Session->win,FALSE);
  /*  nodelay(stdscr,TRUE); noecho(); raw(); */
}

DeleteSession() {
  int i, s;
  if (Session) {
    Sessions[Session->fd] = NULL;
    if (Session->raw_log) fclose(Session->raw_log);
    Session->raw_log = NULL;
    if (Session->cooked_log) fclose(Session->cooked_log);
    Session->cooked_log = NULL;
    delwin(Session->win);
    if (Session->term) free(Session->term);
    if (Session->rawBuff) free(Session->rawBuff);
    if (Session == CurrSession) CurrSession = NULL;
    fclose(Session->inp);
    fclose(Session->outp);
    free(Session);
    Session = NULL;
    --MaxSession;
    for (s=0,i=0; i < MaxSession; ++s)
      if (Sessions[s]) Sessions[s]->num = i++;
  }
}

fatal(message) 
char *message;
{
  int n;

  while (MaxSession) {
    for(n=0; n< WIN_SESSION_MAX; ++n) {
      if (Session = Sessions[n]) {
	DeleteSession();
	break;
      }
    }
  }
  CurrSession=Session=NULL;
  
  if (InitScr) {
    WITH_CURSES({
/*      endwin(); */
      InitScr = 0;
    })}
  if (message) fprintf(stderr,"%s\n",message);
  if (message) exit(-1);
}

SCREEN *TermScreen;
EmulateTerminal(termtype, fd, rows, cols)
int rows, cols;
char *termtype;
int fd;
{
  TermTab *term = NULL;
  extern char *Strdup();
  extern TermTab *EmulateTerm();
  FILE *inp, *outp;
  inp = fdopen(fd, "w");
  if (!inp) return(0);
  outp =  fdopen(fd, "r");
  if (!outp) return(0);
  if (termtype && (term = EmulateTerm(termtype, inp, outp))) {
    InitializeCurses();
/*    if (rows < term->int_lines) rows = term->int_lines; */
    if (rows <= 0) rows = term->int_lines;
    if (rows <= 0 || rows > (LINES - 1)) rows = (LINES - 1);
    if (rows <= 0) rows = 24;
/*    if (cols < term->int_cols) cols = term->int_cols; */
    if (cols <= 0) cols = term->int_cols;
    if (cols <= 0 || cols > COLS) cols = COLS;
    if (cols <= 0) cols = 80;
    { struct winsize ws;
      ws.ws_row = rows; ws.ws_col = cols;
      ws.ws_xpixel = ws.ws_ypixel = 0;
      ioctl(fd, TIOCSWINSZ, &ws);
    }
    if (!SetSessionFromFD(fd)) {
      WITH_CURSES({CreateSession(fd, rows, cols, term->int_lm, cols);});
      Session->term = (TermTab *)malloc(sizeof(TermTab));
    }
    memcpy(Session->term, term, sizeof(TermTab));
    Session->termOriginal = term;
    if (Session->inp)  fclose(Session->inp);
    if (Session->outp) fclose(Session->outp);
    Session->fd = fd;
    Session->inp = inp;
    Session->outp = outp;
    do_reset();
  }
  return(term?1:0);
}
    
#define INPUT_UNREAD_BY_EXPECT -1
#define INPUT_UNREAD_BY_TERM -2
CheckInput(fd, t, any)
int fd;
double t;
int any;
{
  fd_set rdrs;
  struct timeval tv;
  int result = 0;
  
  if (any && SetSessionFromFD(fd) && (Session->rawIndex < Session->rawEnd))
    return(INPUT_UNREAD_BY_TERM);
  DoubleToTimeval(t,&tv);
  FD_ZERO(&rdrs);
  FD_SET(fd,&rdrs);
  if (SetAlarm(t+1.0)) {
    result = -1;
    result = select(1+fd,&rdrs,(fd_set *)0,(fd_set *)0,&tv);
  }
  ClearAlarm();
  if (-1 == result && errno != EINTR) {
    if (errno != EBADF) {
      /* not prepared to handle anything else */
      errorlog("select: %s\r\n",sys_errlist[errno]);
      bye(-1);
    }
    debuglog("Select: Child Died");
    fd_close(fd);
    DeleteSession();
    return(NULL);
  }
  if (result = FD_ISSET(fd, &rdrs)) return(result);
  if (any && Session && (Session->expIndex < Session->rawEnd))
    return(INPUT_UNREAD_BY_EXPECT);
  else return(NULL);
}

HandleSessionTerminal(buf, size, time_out)
int size;
double time_out;
char *buf;
{
  long cc = 0 , iflag;
  debuglog("EXPECTERM:HandleSessionTerminal(%x, %d, %f) [S->expIndex: %d, S->rawIndex %d, S->rawEnd %d, S->rawMax: %d]\r\n", 
	   buf, size, time_out,Session->expIndex,Session->rawIndex, Session->rawEnd, Session->rawMax);
  iflag=CheckInput(Session->fd, time_out, TRUE);
  if (iflag && iflag != INPUT_UNREAD_BY_EXPECT)
    WITH_CURSES(handle_output());
  cc = Session->rawEnd - Session->expIndex;
  if (cc > size) cc = size;
  if (cc > 0) memcpy(buf, (Session->rawBuff + Session->expIndex), cc);
  Session->expIndex += cc;
  if ((Session->rawIndex == Session->rawEnd) &&
      (Session->expIndex == Session->rawEnd))
    Session->rawIndex = Session->rawEnd = Session->expIndex = 0;
  if (cc >= 0 && cc < size) buf[cc]='\0';
  debuglog("EXPECTERM:=> %d, iflag: %d, [S->expIndex: %d, S->rawIndex: %d, S->rawEnd: %d, S->rawMax: %d]\r\n", 
	   cc, iflag, Session->expIndex,Session->rawIndex, Session->rawEnd, Session->rawMax);
  return(cc);
}

char UngetChar(c)
char c;
{
  while(--Session->rawIndex && (Session->rawBuff[Session->rawIndex] != c));
  return(c);
}

double NextchInputWait = 0.0;

char Nextch(waitfor, cptr)
char *cptr;
double waitfor;
{
  char uchar = '\0';
  register long index = Session->rawIndex, end = Session->rawEnd;
  NextchInputWait = waitfor;
  if (SessionBufferedInputP()) return('\0');
  if (index >= end) {
    while (end != -1) {
      int n;
      if (!CheckInput(Session->fd, 0.0, NULL)) {
        if (waitfor == 0.0) break;
        else {
          extern double TimeOfDay();
          double before, after;
          before = TimeOfDay();
          if (!CheckInput(Session->fd, waitfor, NULL)) { 
            NextchInputWait = 0.0; 
            break; 
          }
          after = TimeOfDay();
          NextchInputWait -= (after - before);
          if (NextchInputWait < 0.0) NextchInputWait = 0.0;
          waitfor = 0.0;
        }
      }
      if (end == Session->rawMax) {
	Session->rawMax *= 2;
	Session->rawBuff = (char *)realloc(Session->rawBuff, (Session->rawMax+16));
      }
      n = read(Session->fd, Session->rawBuff+end, Session->rawMax-end);
      if (n <= 0) {
	end = -1; index = 0; /* indicate failure */
	break;
      }
      else {
        register char *b    = (Session->rawBuff + end);
        char *bmax = (Session->rawBuff + end + n);
        while (b<bmax) { if (!(*b &= BITS7)) *b = NUL; ++b; }
        if (Session->raw_log) write(fileno(Session->raw_log),(Session->rawBuff + end),n);
        end += n;
        Session->rawBuff[end]='\0';
      }
    }
  }
  if (index < end) {
    uchar = Session->rawBuff[index++];
    if (cptr) *cptr = uchar;
  }
  Session->rawIndex = index;
  Session->rawEnd = end;
  return(uchar);
}

char charyx(y,x)
long y,x;
{
  if (x>(Session->columns-1) || x < 0 || y>(Session->rows-1) || y < 0) return('\0');
  return(Session->win->_y
	 ? (Session->win->_y[y][x]  & ~A_ATTRIBUTES)
	 : ' ');
}

char attryx(y,x)
long y,x;
{
  long attr;
  if (x>(Session->columns-1) || x < 0 || y>(Session->rows-1) || y < 0) return('\0');
  attr=(Session->win->_y)?(Session->win->_y[y][x] & A_ATTRIBUTES):0L;
  if (!attr) return('N');
  if (attr & A_PROTECT) return('P');
  if (attr & A_INVIS) return('I');
  if (attr & A_BOLD) return('B');
  if (attr & A_STANDOUT) return('S');
  if (attr & A_UNDERLINE) return('U');
  if (attr & A_ALTCHARSET) return('A');
  if (attr & A_REVERSE) return('R');
  if (attr & A_DIM) return('D');
  if (attr & A_BLINK) return('b');
  return('?');
}

BFLUSH(drain)
int drain;
{
  if (Session->cooked_log) {
    char string[XMAX], *s;
    int x, y=Session->y, xmax = (drain ? Session->columns : Session->x);
    for(s=string, x=Session->cookedIndex; x<xmax && (*s = charyx(y,x)); ++x, ++s);
    if (drain) *s++ = '\n';
    else Session->cookedIndex = x;
    *s = 0;
    fwrite(string,strlen(string),1,Session->cooked_log);
    fflush(Session->cooked_log);
  }
  if (drain) Session->cookedIndex = 0;
}

Go(ny,nx)
long ny, nx;
{
  long dx;
  if (Session->x >= Session->columns && ny == Session->y && (Session->term->bool_am==1)) {/* wraps right */
    ++ny; nx=XMIN;
  }
  if (nx < 0 && (Session->term->bool_bw==1)) nx = Session->columns-nx; /* wrap left */
  if (nx >= Session->columns) nx = Session->columns-1;
  else if (nx < 0) nx = (Session->term->bool_bw==1) ? (Session->columns+nx) : 0;
  if (ny < (Session->y) || (ny == (Session->y) && nx < (Session->x)) || 
      ny < TMARG(Session) || ny > BMARG(Session))
    CacheInput();
  dx = (((Session->y)==ny) && ((Session->x) < nx)) ? (nx - (Session->x)) : 0;
/*  while (dx-- > 0) BPUTC(Session,charyx((Session->y),(Session->x))); */
  if (ny != (Session->y)) { Session->dribble_p=1; BFLUSH(1); }
  else if (nx < (Session->x)) BFLUSH(1);
  while (ny > BMARG(Session)) {
    wmove(Session->win,TMARG(Session),0);
    wdeleteln(Session->win);
    wmove(Session->win,BMARG(Session),0);
    winsertln(Session->win);
    --ny;
  }
  while (ny < TMARG(Session)) {
    wmove(Session->win,BMARG(Session),0);
    wdeleteln(Session->win);
    wmove(Session->win,TMARG(Session),0);
    winsertln(Session->win);
    ++ny;
  }
  wmove(Session->win,ny,nx);
  getyx(Session->win,Session->y,Session->x);
}

BPUTC(Session, c)
SESSION *Session;
char c;
{
  Session->input_p=TRUE;
  Session->dribble_p=1;
  if ((Session->x) >= (Session->columns) && (Session->term->bool_am==1)) /* wraps right */
    Go(Session->y+1, XMIN);
  if ((Session->x) >= Session->columns && (Session->term->bool_am!=1)) /* wraps right */
    Go(Session->y, Session->columns-1);
  if (Session->term->Local || !Session->term->InsertMode) {
    int oattrs;
    if (Session->term->Local) NextField(0);
    else Break();
    oattrs = Session->win->_attrs;
    wattrset(Session->win, (Session->win->_y[Session->y][Session->x] & A_ATTRIBUTES));
    waddch(Session->win,c);
    wattrset(Session->win, oattrs);
  }
  else {
    if (Session->win->_attrs & A_ALTCHARSET && Session->term->str_acsc > (char *)0) {
      char *acsc = Session->term->str_acsc;
      while (*acsc && *(++acsc) != c) ++acsc;
      if (*acsc) c = *(acsc-1);
    }
    waddch(Session->win,c);
  }
  ++(Session->x);
}

Write(fd, buf, siz)
int fd;
char *buf;
unsigned siz;
{
  if (!SetSessionFromFD(fd)) return(write(fd, buf, siz));
  if ((Session->term->Local == 1) || Session->echop) {
    while (Session->rawEnd+siz >= Session->rawMax) {
      Session->rawMax *= 2;
      Session->rawBuff = (char *)realloc(Session->rawBuff, (Session->rawMax+16));
    }
    strncpy(Session->rawBuff+Session->rawEnd, buf, siz);
    Session->rawEnd += siz;
    WITH_CURSES(handle_output());
    UpdateWindow(NULL);
  }
  if (Session->term->Local == 1)
    return(siz);
  else
    return(write(fd, buf, siz));
}

NextField(count)
int count;
{
  int x=Session->x, y=Session->y, inc = ((count < 0) ? -1 : 1);
  if (count < 0) count = -count;
  if (Session->win->_y) {
    do {
      int saw00=0;
      if (count)
	while (attryx(y,x) == 'P') {
	  x+=inc;
	  if (x<0) {if (--y<0) y=Session->rows-1; x = Session->columns-1; break;}
	  else if (x >= Session->columns) {if(++y>=Session->rows) y=0; x=0;break;}
	}
      while (attryx(y,x) != 'P') {
	if (!x && !y) if (++saw00 > 1) break;
	x+=inc;
	if (x<0) {if (--y<0) y=Session->rows-1; x = Session->columns-1;}
	else if (x >= Session->columns) {if(++y>=Session->rows) y=0; x=0;}
      }
    } while(--count > 0);
    Go(y, x);
  }
}

static char *StatusLine = NULL;
int StatusLineIsDefaultP=TRUE;

char *SetStatusLine(statusline)
char *statusline;
{
  static char buf[265];
  extern int fd_max;
  StatusLine = buf;
  if (statusline == WIN_DEFAULT_WINBAR || 
      (!statusline && StatusLineIsDefaultP)) {
    StatusLineIsDefaultP=1;
    if (!Session) {
      sprintf(StatusLine,
              "Flags: ????? Session:-1/0 Master:-1/%x x:-1/0 y:-1/0 *NONE*",
              fd_max);
    }
    else if (Session == CurrSession)
      sprintf(StatusLine,
              "Flags: %c%c%c%c%c Session:%x/%x Master:%x/%x x:%02d/%2d y:%02d/%2d %s",
              (Session->crnlp?'C':'c'),
              (Session->echop?'E':'e'),
              (Session->tabspacep?'T':'t'),
              (Session->raw_log?'R':'r'),
              (Session->cooked_log?'L':'l'),
              Session->num,MaxSession-1,
              Session->fd, fd_max,
              Session->x, Session->columns-1,
              Session->y, Session->rows-1,
              Session->term->type);
  }
  else if (!statusline) return(NULL);
  else if (statusline != WIN_DEFAULT_WINBAR) {
    StatusLineIsDefaultP = 0;
    strncpy(StatusLine,statusline,(COLS?COLS:80));
  }
  strcat(StatusLine,"                                                                               ");
  StatusLine[(COLS?COLS:80)-1]='\0';
  return(StatusLine);
}

char *GetStatusLine() {
  if (!StatusLine) SetStatusLine(WIN_DEFAULT_WINBAR);
  return(StatusLine);
}

long winbar(force)
int force;
{
  static SESSION *osession=NULL;
  static struct _win_st *wb=NULL;
  long oy=0, ox=0;
  extern loguser;
  extern char in_curses;
  int CurrP = (Session == CurrSession);
  struct winsize ws;

/*  if (!InitScr) InitializeCurses(); */
  if (!InitScr || !loguser) return(0);
  if (!force && (!CurrSession || !CurrP)) return(0);

  if (!wb && WinbarP) {
    int row = LINES, n;
    if (row <= 0) row = 25;
    wb = (struct _win_st *)newwin(0,0,row-1,0);
    if (!wb) { 
      struct _win_st *s = stdscr;
      fatal("Could Not Create Winbar! Try bigger window."); 
      exit(-1); 
    }
  }
  if (wb) {
    wstandout(wb);
    mvwprintw(wb,0,0,"%s",StatusLine);
    wstandend(wb);
  }
  if (Session != osession || force) {
    if (Session) touchwin(Session->win); 
    osession = Session; 
  }
  if (Session) {
    getyx(Session->win,oy,ox);
    wmove(Session->win,oy,ox);
  }
  if (WinbarP && wb && force) touchwin(wb);
  if (WinbarP && wb && in_curses) wrefresh(wb);
  if (in_curses && Session)
    REFRESH(Session->win, 
            Session->pad.minrow, Session->pad.mincol,
            0, 0, Session->rows, Session->columns);
  return(1);
}



