'\" 
'\" Copyright 1993 David Herron.
'\" Permission to use, copy, modify and distribute this software
'\" and its documentation for any purpose and without fee is
'\" hereby granted, provided that the above copyright notice
'\" appear in all copies.  David Herron makes no representations
'\" about the suitability of this software for any purpose save
'\" printing it out and using the paper as bird cage lining.
'\" 
.\" $Id: interpApi.man,v 1.2 1993/06/08 06:14:49 david Exp $
.\"
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"     Replacement for .TH in other man pages.  See below for valid
.\"     section names.
.\"
.\" .AP type name in/out [indent]
.\"     Start paragraph describing an argument to a library procedure.
.\"     type is type of argument (int, etc.), in/out is either "in", "out",
.\"     or "in/out" to describe whether procedure reads or modifies arg,
.\"     and indent is equivalent to second arg of .IP (shouldn't ever be
.\"     needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"     Give maximum sizes of arguments for setting tab stops.  Type and
.\"     name are examples of largest possible arguments that will be passed
.\"     to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"     Start box enclosure.  From here until next .BE, everything will be
.\"     enclosed in one large box.
.\"
.\" .BE
.\"     End of box enclosure.
.\"
.\" .VS
.\"     Begin vertical sidebar, for use in marking newly-changed parts
.\"     of man pages.
.\"
.\" .VE
.\"     End of vertical sidebar.
.\"
.\" .DS
.\"     Begin an indented unfilled display.
.\"
.\" .DE
.\"     End of indented unfilled display.
.\"
'\"     # Heading for Tcl/Tk man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"     # Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1  \\fI\\$2\\fP    (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1  \\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"     # define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"     # BS - start boxed text
'\"     # ^y = starting y location
'\"     # ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"     # BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"     Draw four-sided box normally, but don't draw top of
.\"     box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"     # VS - start vertical sidebar
'\"     # ^Y = starting y location
'\"     # ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"     # VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"     # Special macro to handle page bottom:  finish off current
'\"     # box/sidebar if in box/sidebar mode, then invoked standard
'\"     # page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"     Draw three-sided box if this is the box's first page,
.\"     draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h
'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"     # DS - begin display
.de DS
.RS
.nf
.sp
..
'\"     # DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS interpApi cmds
.BS
.SH NAME
interpAPI \- C Programmers API to the \fIminterp\fP of manipulating multiple TCL interpretors.
.SH SYNOPSIS

struct interpInfo {
.br
\ \ \ \ Tcl_Interp *interp;		/* Which interpretor it is */
.br
\ \ \ \ char	   *name;		/* What its name is */
.br
\ \ \ \ char	   *destroyHook;	/* What to do before killing it */
.br
\ \ \ \ short	    allowExec;		/* Allow for -exec to happen here */
.br
\ \ \ \ Tcl_HashTable methods;		/* Table of `method' names */
.br
};
.br
void   init_interp(interp);
.br
int    Int_MainInterp(interp);
.br
struct interpInfo *Int_CreateInterp(interp, new_interp, name);
.br
struct interpInfo *Int_findInterp(name);
.br
struct interpInfo *Int_whoIs(interp);
.br
int    Int_delInterp(interp, info);
.br
int    Int_ExecCommand(this-interp, other-interp, argc, argv);
.br
void   Int_copyErrorInfo (source-interp-info, dest-interpretor);
.br
int    Int_AddMethod(info, name);
.br
int    Int_DelMethod(info, name);
.BE

.SH DESCRIPTION
.PP

.SH FUNCTIONS

.TP
init_interp
Initialize \Iminterp\fP.  Adds the \fBinterp\fP command to the
interpretor but does not associate \fBMainInterp\fP with that interpretor.

.TP
Int_MainInterp
Defines \fIinterp\fP to be \fBMainInterp\fP and changes the commands
to match that defined in the \fIinterp\fP man page.

.TP
Int_CreateInterp
Creates a new interpretor named \fIname\fP, and fills in an \fIinterpInfo\fP
structure with interesting information.  If \fInew_interp\fP is non-NULL,
this is taken to be the interpretor to use instead of creating a brand
new one.

The commands in the interpretor are as documented in the \fIinterp\fP man page.
A command is created, named \fIname\fP, in all the other interpretors as
documented there.

.TP
Int_findInterp
Finds the \fIinterpInfo\fP structure for the named interpretor.  If none
is found then NULL is returned.

.TP
Int_whoIs
Finds the \fIinterpInfo\fP structure for the interpretor.  If none
is found then NULL is returned.

.TP
Int_delInterp
Kills the interpretor pointed to in \fIinfo\fP.  If there is a \fIdestroy
hook\fP it is executed.  If the result from that is not TCL_OK then the
deletion is aborted and error information is returned through \fIinterp\fP.
The interpretors commands are removed from the other interpretors.

.TP
Int_ExecCommand
Takes an already parsed command in \fIargv\fP/\fIargc\fP.  Retrieves
the command named in \fIargv[0]\fP from \fIother\fP and calls its
command handling procedure.  Except the \fIinterp\fP passed is
\fIthis\fP instead of \fIother\fP.

If the command cannot be found then \fIunknown\fP is retrieved from
\fIthis\fP and executed in \fIthis\fP.

.TP
Int_copyErrorInfo
Copy the error information from \fIsource-interp\fP to \fIdest-interp\fP.

.TP
Int_AddMethod
Adds the \fIname\fP to the \fIMethod\fP list in \fIinfo\fP.

.TP
Int_DelMethod
Deletes the named method.
.SH AUTHOR
David Herron <david@davids.mmdf.com (home)>

.SH BUGS
Knock on wood ...
