source narray.tcl

proc msg {msg} {
    puts "### $msg"
}

proc run body {
    if {[catch [list uplevel $body]] == 1} {
	global errorInfo
	puts stderr $errorInfo
    }
}

set debug 4

run {
    msg "Making f a 20x20 matrix"
    narray create f 20 20
    f debug $debug
    puts [string trim [f status]]

    msg "Setting matrix to floor(10 * sin(x * y))..."
    f map {
	[] = floor(10 * sin(@0 * @1));
    }

    msg "Result:"
    pnarray f
}
