#
# $Id: html.tcl,v 1.2 1994/08/04 23:51:12 sls Exp $
#
#
# This software is copyright (C) 1994 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
# html support routines
#
# html(sink) -- proc that prints some text
# html(style) -- current style
# html(style_table) -- table of style names and begin/end directives
#

set html(sink) puts
set html(style) normal
set html(style_table) {
    {normal "" ""}
    {bold <B> </B>}
    {strong <STRONG> </STRONG>}
    {em <EM> </EM>}
    {italic <I> </I>}
    {site <SITE> </SITE>}
    {var <VAR> </VAR>}
    {tt <TT> </TT>}
    {code <CODE> </CODE>}
    {samp <SAMP> </SAMP>}
    {kbd <KBD> </KBD>}
}

proc html_dnl {} {
    global html
    if {$html(sink) == "puts"} {
	set html(sink) html_dnl_sink
    }
}

proc html_dnl_sink {txt} {
    puts -nonewline $txt 
}

proc html_nl {} {
    global html
    if {$html(sink) == "html_dnl_sink"} {
	set html(sink) puts
    }
}

proc html_quote {text} {
    global html
    regsub -all "&" $text "\\&amp;" text
    regsub -all "<" $text "\\&lt;" text
    regsub -all ">" $text "\\&gt;" text
    $html(sink) $text
}

proc html {txt} {
    global html
    $html(sink) $txt
}

proc html_style_lookup {s} {
    global html
    foreach e $html(style_table) {
	if {[lindex $e 0] == $s} {
	    return $e
	}
    }
    error "unknown html style \"$s\""
}

proc html_set_style {s} {
    global html
    if {$s != $html(style)} {
	html [lindex [html_style_lookup $html(style)] 2]
	html [lindex [html_style_lookup $s] 1]
	set html(style) $s
    }
}

proc html_style {s txt} {
    global html
    set old_style $html(style)
    html_set_style $s
    html $txt
    html_set_style $old_style
}

proc html_begin {title} {
    html "<HTML><HEADER>"
    html "<TITLE>$title</TITLE>"
    html "</HEADER><BODY>"
}

proc html_end {} {
    global html
    if {[info commands html_sign] != ""} html_sign
    html "</BODY></HTML>"
}

proc html_heading {hdr {level 1}} {
    html "<H$level>$hdr</H$level>"
}

proc html_run {body} {
    if {[catch {uplevel $body}] == 1} {
	global errorInfo
	html "<HR><H1>Ooops!</H1>An error occurred in a tcl script:"
	html "<LISTING>"
	html "$errorInfo"
	html "</LISTING>"
	html "</HR>"
    }
}
