#
# $Id: wwwdemo_body.tcl,v 1.4 1994/08/05 04:00:43 sls Exp $
#
# This software is copyright (C) 1994 by the Lawrence Berkeley Laboratory.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that: (1) source code distributions
# retain the above copyright notice and this paragraph in its entirety, (2)
# distributions including binary code include the above copyright notice and
# this paragraph in its entirety in the documentation or other materials
# provided with the distribution, and (3) all advertising materials mentioning
# features or use of this software display the following acknowledgement:
# ``This product includes software developed by the University of California,
# Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
# the University nor the names of its contributors may be used to endorse
# or promote products derived from this software without specific prior
# written permission.
# 
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#

proc html_sign {} {
    html "<HR><ADDRESS><a href=http://www-cs.lbl.gov/~sls/>Sam Shen</a>, slshen@lbl.gov</ADDRESS>"
}

narray cripple

puts "Content-type: text/html"
puts ""

html_run {
    if {[info exists env(REQUEST_METHOD)] && [string tolower $env(REQUEST_METHOD)] == "post"} {
	cgi_post_read
    }
    html_begin "NArray Demo"
    html_heading "NArray Demo"

    html "This is a demo of the narray extension."
    html "The Tcl code you enter below will be evaluated in a restricted"
    html "Tcl interpreter line by line, giving the command result and"
    html "time taken.  Your code will be limited to 20 seconds of cpu"
    html "time, 4M of data, and 64K of stack.  If you exceed these limit"
    html "the server will be unable to complete your request."

    if [info exists ar(code)] {
	set cmd ""
	html_heading "Previous results:" 2
	foreach line [split $ar(code) \n] {
	    append cmd "$line\n"
	    if [info complete $cmd] {
		if ![string length [string trim $cmd]] continue
		html_set_style bold
		html_quote $cmd
		html_set_style normal
		html "<ul>"
		html "<li> Stdout: "
		html_set_style tt
		if [catch {set t [time {set result [eval $cmd]}]}] {
		    html_set_style normal
		    html "<li> Error: "
		    html "<listing>"
		    html $errorInfo
		    html "</listing>"
		} else {
		    html_set_style normal
		    html \
		  "<li> Time: [format %3.2f [expr [lindex $t 0] / 1000.0]]ms"
		    html "<li> Result: "
		    html_set_style tt
		    html_quote $result
		    html_set_style normal		    
		}
		html "</ul>"
		set cmd ""
	    }
	}
    }
    html_heading "Enter Tcl code:" 2
    form_begin wwwdemo.cgi
    submit -value "Evaluate Code"
    html "<P>"
    html_dnl
    textarea_begin -name code -rows 15 -cols 60
    if [info exists ar(code)] {
	html_quote $ar(code)
    }
    textarea_end
    html_nl
    form_end
    html_end
}
