/* Variadic arguments
 *
 * TCL uses old style varargs. To ensure that stdargs is not used, the
 * file is included here and all the definitions removed.
 */
#include <stdarg.h>
#undef va_start
#undef va_end
#undef va_arg
#include <varargs.h>

/* VxWorks specials
 *
 * Include all general VxWorks inclusions up front to get them out of the way.
 */

#include "vxWorks.h"
#include "taskLib.h"

/* Time
 *
 * WRS hasn't done such a wonderful job with the ANSI time support.
 */

#include <time.h>

struct tms {
   clock_t tms_utime;		/* user time */
   clock_t tms_stime;		/* system time */
   clock_t tms_cutime;		/* user time, children */
   clock_t tms_cstime;		/* system time, children */
};

#define CLK_TCK sysClkRateGet()
#define times(x) (clock())

/* Process wait support
 *
 * Just pretend that this exists. There is a dummy waitpid() function
 * defined in the compatibility file.
 */
#define WNOHANG 0

/* Thread support
 *
 * Enable thread support within TCL.
 */
#define MULTI_THREAD

/* No main
 *
 * The name of the main entry point is changed. Note that the name of
 * the entry point for VxWorks is tclMain. It will do some preliminary
 * setup, then call tclStart.
 */
#define main tclStart

/* Environment
 *
 * The environment is available directly from VxWorks.
 */
extern char **ppGlobalEnviron;
#include "envLib.h"

/* Change working directory
 *
 * Unfortunately cd() does what chdir() should probably do.
 */
#include <unistd.h>
#define chdir(x) ( cd(x) == OK ? 0 : -1 )

/* No pipeline support
 *
 * It is not possible to create a pipelines so pipe and fork support can be
 * removed.
 */
#include <unistd.h>
#define pipe(x)     (-1)
#define fork()      (-1)
#define dup2(x,y)   (-1)
#define execvp(x,y) (-1)
#define _exit       exit

/* No symbolic link support
 *
 * Removing the definition of S_IFLNK causes TCL to drop support for
 * symbolic links.
 */
#include <sys/stat.h>
#undef S_IFLNK

/* Process id
 *
 * Redefine this to be the task id.
 */
#include <unistd.h>
#define getpid taskIdSelf

/* Effective user id
 *
 * There is no record of the current user, so simply claim that the
 * user owns everything. This is incorrect, but seems to be less
 * likely to stop programs. This implementation is very chummy with
 * the users of geteuid().
 */
#include <unistd.h>
#define geteuid() statBuf.st_uid
