/* 
 * tmCreateWidget.c --
 *
 *	This module implements the tcl binding to Motif
 *	of the XmCreate... functions
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Copyright 1990-1992 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header: /usrs/tm/RCS/tmPushButton.c,v 1.2 1993/07/14 20:01:43 jan Exp jan $ SPRITE (Berkeley)";
#endif

#include "tm.h"
#include "tmFuncs.h"

#ifndef MOTIF11
#include <Xm/XmAll.h>
#else
#include <Xm/ArrowB.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/Command.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#endif  /* MOTIF11 */

/*
 * this is the list of resources that require the widget rather
 * than its parent for proper conversions from String.
 *
 * This is really quite gross, and a yukky maintainance problem.
 * Besides which, apart from reading oodles of Motif source
 * code, how am I supposed to know what is in this list?
 * Is it dependant on Motif versions?
 *
 * OSF should leap into action and supply a fix for this
 */
static char *dont_use_parent_for_resources[] = {
	"width",
	"height",
	"x",
	"y",
	"marginBottom",
	"marginHeight",
	"marginLeft",
	"marginRight",
	"marginTop",
	"marginWidth",
	"borderWidth",
	"highlightThickness",
	"shadowThickness",
	"sashWidth",
	"sashHeight",
	"labelPixmap",
/*	"labelType",	 this needn't be here, except size calcs go wrong */
};

/*
 *--------------------------------------------------------------
 *
 * DontUseParentForResources --
 *
 *	Some widgets use properties of the widget in setting
 *	resource values. For these resources the parent cannot
 *	be used. This function checks on these widgets
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

static Boolean
DontUseParentForResources(s)
    char *s;
{
    int n;

    for (n = 0; n < XtNumber(dont_use_parent_for_resources); n++) {
	if (strcmp(s, dont_use_parent_for_resources[n]) == 0) {
	    return True;
	}
    }
    return False;
}

/*
 *--------------------------------------------------------------
 *
 * DivideArgs --
 *
 *	Some resources can only be set at create time, so must be
 *	converted *before* the create function. e.g. the
 *	ScrollingPolicy of a ScrolledWindow. Others must be converted
 *	after the widget is created as they use widget values e.g.
 *	the labelPixmap requires fg and bg, and width and all other
 *	dimensions require the UnitType value. This function divides
 *	the resources into before and after sets. Many resources have
 *	no special requirement so are arbitrarily put into the before
 *	list.
 *
 *	This code cannot handle this case: the widget itself
 *	needs to be used, but the value can only be set in the
 *	widget Initialise routine. Fortunately this does not yet
 *	occur, or it will break every Motif binding based on a
 *	string type.
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

static void
DivideArgs(argv, argc, parent_args, num_parent_args,
                        child_args, num_child_args)
    char *argv[];
    int argc;
    char *parent_args[];
    int *num_parent_args;
    char *child_args[];
    int *num_child_args;
{
    int child, parent, n;

    child = parent = 0;
    for (n = 0; n < argc; True) {
	if (DontUseParentForResources(argv[n]+1)) {
	    if (child + 3 > TM_MAXARGS) {
		fprintf(stderr, "too many args: %s\n", argv[n]);
		return;
	    }
	    child_args[child++] = argv[n++];
	    child_args[child++] = argv[n++];
	} else {
	    if (parent + 3 > TM_MAXARGS) {
		fprintf(stderr, "too many args: %s\n", argv[n]);
		return;
	    }
	    parent_args[parent++] = argv[n++];
	    parent_args[parent++] = argv[n++];
	}
    }
    *num_parent_args = parent;
    *num_child_args = child;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_AnyCmd --
 *
 *	This procedure is invoked to process the "ordinary"
 *	widget Tcl commands.  See the
 *	user documentation for details on what it does.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */

int
Tm_AnyCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{

    register Tm_Widget *wPtr;
    Widget new, parent;
    char *command = argv[0];
    char *path = argv[1];
    Arg args[TM_MAXARGS];
    int num_args;
    char *parent_argv[TM_MAXARGS], *child_argv[TM_MAXARGS];
    int num_parent_argc, num_child_argc;
    WidgetClass class;
    Tm_WidgetCmdProc widgetCmdProc;
    Boolean managed = False;
    Tcl_CmdInfo parentInfo;
 
    widgetCmdProc = (Tm_WidgetCmdProc) clientData;

    parent = Tm_ParentWidgetFromPath (interp, path);
    if (parent == NULL)
	return TCL_ERROR;

    if (strcmp(command, ArrowButton) == 0) {
	class = xmArrowButtonWidgetClass;
    } else
    if (strcmp(command, BulletinBoard) == 0) {
	class = xmBulletinBoardWidgetClass;
    } else
    if (strcmp(command, CascadeButton) == 0) {
	class = xmCascadeButtonWidgetClass;
    } else
    if (strcmp(command, Command) == 0) {
	class = xmCommandWidgetClass;
    } else
    if (strcmp(command, DrawingArea) == 0) {
	class = xmDrawingAreaWidgetClass;
    } else
    if (strcmp(command, DrawnButton) == 0) {
	class = xmDrawnButtonWidgetClass;
    } else
    if (strcmp(command, FileSelectionBox) == 0) {
	class = xmFileSelectionBoxWidgetClass;
    } else
    if (strcmp(command, Form) == 0) {
	class = xmFormWidgetClass;
    } else
    if (strcmp(command, Frame) == 0) {
	class = xmFrameWidgetClass;
    } else
    if (strcmp(command, List) == 0) {
	class = xmListWidgetClass;
    } else
    if (strcmp(command, Label) == 0) {
	class = xmLabelWidgetClass;
    } else
    if (strcmp(command, MainWindow) == 0) {
	class = xmMainWindowWidgetClass;
    } else
    if (strcmp(command, MessageBox) == 0) {
	class = xmMessageBoxWidgetClass;
    } else
    if (strcmp(command, PanedWindow) == 0) {
	class = xmPanedWindowWidgetClass;
    } else
    if (strcmp(command, PushButton) == 0) {
	class = xmPushButtonWidgetClass;
    } else
    if (strcmp(command, Scale) == 0) {
	class = xmScaleWidgetClass;
    } else
    if (strcmp(command, ScrollBar) == 0) {
	class = xmScrollBarWidgetClass;
    } else
    if (strcmp(command, ScrolledWindow) == 0) {
	class = xmScrolledWindowWidgetClass;
    } else
    if (strcmp(command, SelectionBox) == 0) {
	class = xmSelectionBoxWidgetClass;
    } else
    if (strcmp(command, Separator) == 0) {
	class = xmSeparatorWidgetClass;
    } else
    if (strcmp(command, Text) == 0) {
	class = xmTextWidgetClass;
    } else
    if (strcmp(command, TextField) == 0) {
	class = xmTextFieldWidgetClass;
    } else
    if (strcmp(command, ToggleButton) == 0) {
	class = xmToggleButtonWidgetClass;
    } else {
	return TCL_ERROR;
    }

    if (argc >= 3 && strcmp(argv[2], "managed") == 0) {
	managed = True;
	argv++;
	argc--;
    }

    /* make sure class is initialized before using XtConvertAndStore */
    XtInitializeWidgetClass(class);

    DivideArgs(argv + 2, argc - 2, parent_argv, &num_parent_argc,
			child_argv, &num_child_argc);
    Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
    new = XtCreateWidget (Tm_NameFromPath(path), class, parent, args, num_args);
    Tm_SetValues(path, interp, new, parent, class,
				child_argv, num_child_argc, args, &num_args);
    XtSetValues(new, args, num_args);
    
    if (managed) {
        XtManageChild (new);
    }

    wPtr = (Tm_Widget *) XtMalloc (sizeof (Tm_Widget));
    wPtr -> interp = interp;
    wPtr -> widget = new;
    wPtr -> pathName = XtNewString(path);
    wPtr -> parent = Tm_ParentPath(path);
    wPtr -> dropProc = NULL;

    Tcl_GetCommandInfo(interp, wPtr->parent, &parentInfo);
    wPtr -> displayInfo = ((Tm_Widget *) parentInfo.clientData)->displayInfo;

    Tm_StoreWidgetInfo(path, wPtr, interp);
    XtVaSetValues(new, XmNuserData, wPtr, NULL);

    Tcl_CreateCommand (interp, path, widgetCmdProc,
		 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(new, XmNdestroyCallback, Tm_DestroyWidgetHandler,
	(XtPointer) wPtr);
			

   Tcl_SetResult(interp, wPtr -> pathName, TCL_VOLATILE);
    return TCL_OK;
}


/*
 *--------------------------------------------------------------
 *
 * CreateChild --
 *
 *	This procedure is used to create tcl commands for 
 *	the following commands that handle widgets with children
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

static void
CreateChild(interp, path, w, name)
    Tcl_Interp *interp;
    char *path;
    Widget w;
    char *name;
{
    char *subobject_path;
    Tm_Widget *wPtr;
    Tcl_CmdInfo cmdInfo;

    subobject_path = XtMalloc(strlen(path) + strlen(name) + 2);
    strcpy(subobject_path, path);
    strcat(subobject_path, ".");
    strcat(subobject_path, name);

    Tcl_GetCommandInfo(interp, path, &cmdInfo);

    wPtr = (Tm_Widget *) XtMalloc (sizeof (Tm_Widget));
    wPtr -> interp = interp;
    wPtr -> widget = w;
    wPtr -> pathName = subobject_path;
    wPtr -> parent = path;
    wPtr -> dropProc = NULL;
    wPtr -> displayInfo = ((Tm_Widget *) cmdInfo.clientData)->displayInfo;

    Tm_StoreWidgetInfo(subobject_path, wPtr, interp);
    XtVaSetValues(w, XmNuserData, wPtr, NULL);

    Tcl_CreateCommand (interp, subobject_path, Tm_AnyWidgetCmd,
    	 (ClientData) wPtr, (void (*) ()) NULL);
        
    XtAddCallback(w, XmNdestroyCallback, Tm_DestroyWidgetHandler,
	(XtPointer) wPtr);
}


/*
 *--------------------------------------------------------------
 *
 * SelectionBoxCreateChild --
 *
 *	This procedure is used to create tcl commands for 
 *	SelectionBox children
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

static void
SelectionBoxCreateChild(interp, path, parent, type, name)
    Tcl_Interp *interp;
    char *path;
    Widget parent;
    unsigned char type;
    char *name;
{
    Widget w;

    if ((w = XmSelectionBoxGetChild(parent, type)) != NULL) {
	CreateChild(interp, path, w, name);
    }
}


/*
 *--------------------------------------------------------------
 *
 * FileSelectionBoxCreateChild --
 *
 *	This procedure is used to create tcl commands for 
 *	SelectionBox children
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

static void
FileSelectionBoxCreateChild(interp, path, parent, type, name)
    Tcl_Interp *interp;
    char *path;
    Widget parent;
    unsigned char type;
    char *name;
{
    Widget w;

    if ((w = XmFileSelectionBoxGetChild(parent, type)) != NULL) {
	CreateChild(interp, path, w, name);
    }
}


/*
 *--------------------------------------------------------------
 *
 * MessageBoxCreateChild --
 *
 *	This procedure is used to create tcl commands for 
 *	MessageBox children
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

static void
MessageBoxCreateChild(interp, path, parent, type, name)
    Tcl_Interp *interp;
    char *path;
    Widget parent;
    unsigned char type;
    char *name;
{
    Widget w;

    if ((w = XmMessageBoxGetChild(parent, type)) != NULL) {
	CreateChild(interp, path, w, name);
    }
}

/*
 *--------------------------------------------------------------
 *
 * ScrolledWindowCreateChild --
 *
 *	This procedure is used to create tcl commands for 
 *	ScrolledWindow children
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

static void
ScrolledWindowCreateChild(interp, path, parent, type, name)
    Tcl_Interp *interp;
    char *path;
    Widget parent;
    String type;
    char *name;
{
    Widget w;

    XtVaGetValues(parent, type, &w, NULL);
    if (w != NULL) {
	CreateChild(interp, path, w, name);
    }
}

/*
 *--------------------------------------------------------------
 *
 * Tm_HasChildrenCmd --
 *
 *	This procedure is invoked to process the widget commands
 *	that create children, but are not dialogs.
 *	See the
 *	user documentation for details on what it does.
 *	These create a hidden parent, which is the popup shell
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */

int
Tm_HasChildrenCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{
    char *command = argv[0];
    char *path = argv[1];
    Widget new;
    Tcl_CmdInfo cmdInfo;

    if (Tm_AnyCmd(clientData, interp, argc, argv) == TCL_ERROR)
	return TCL_ERROR;

    Tcl_GetCommandInfo(interp, path, &cmdInfo);

    new = ((Tm_Widget *) cmdInfo.clientData)->widget;

    if (strcmp(command, SelectionBox) == 0) {
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_APPLY_BUTTON, "Apply");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_CANCEL_BUTTON, "Cancel");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_HELP_BUTTON, "Help");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_LIST, "ItemsList");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_LIST_LABEL, "Items");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_OK_BUTTON, "OK");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_SELECTION_LABEL, "Selection");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_SEPARATOR, "Separator");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_TEXT, "Text");

	return TCL_OK;
    }

    if (strcmp(command, MessageBox) == 0) {
	MessageBoxCreateChild(interp, path, new, XmDIALOG_CANCEL_BUTTON, "Cancel");
	MessageBoxCreateChild(interp, path, new, XmDIALOG_HELP_BUTTON, "Help");
	MessageBoxCreateChild(interp, path, new, XmDIALOG_MESSAGE_LABEL, "Message");
	MessageBoxCreateChild(interp, path, new, XmDIALOG_OK_BUTTON, "OK");
	MessageBoxCreateChild(interp, path, new, XmDIALOG_SEPARATOR, "Separator");
	MessageBoxCreateChild(interp, path, new, XmDIALOG_SYMBOL_LABEL, "Symbol");

	return TCL_OK;
    }

    if (strcmp(command, FileSelectionBox) == 0) {
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_APPLY_BUTTON, "Apply");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_CANCEL_BUTTON, "Cancel");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_DIR_LIST, "DirList");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_DIR_LIST_LABEL, "Dir");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_FILTER_LABEL, "FilterLabel");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_FILTER_TEXT, "FilterText");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_HELP_BUTTON, "Help");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_LIST, "ItemsList");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_LIST_LABEL, "Items");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_OK_BUTTON, "OK");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_SELECTION_LABEL, "Selection");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_SEPARATOR, "Separator");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_TEXT, "Text");

	return TCL_OK;
    }

    if (strcmp(command, ScrolledWindow) == 0) {
	ScrolledWindowCreateChild(interp, path, new, XmNhorizontalScrollBar,
				"HorScrollBar");
	ScrolledWindowCreateChild(interp, path, new, XmNverticalScrollBar,
				"VertScrollBar");
	ScrolledWindowCreateChild(interp, path, new, XmNclipWindow,
				"ClipWindow");

	return TCL_OK;
    }

    return TCL_ERROR;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_DialogCmd --
 *
 *	This procedure is invoked to process the "...Dialog"
 *	Tcl commands.  See the
 *	user documentation for details on what it does.
 *	These create a hiddne parent, which is the popup shell
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */

/* ARGSUSED */
int
Tm_DialogCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{

    register Tm_Widget *wPtr;
    Widget new, parent;
    char *command = argv[0];
    char *path = argv[1];
    char *dialog_path;
    Arg args[TM_MAXARGS];
    int num_args;
    char *parent_argv[TM_MAXARGS], *child_argv[TM_MAXARGS];
    int num_parent_argc, num_child_argc;
    WidgetClass class;
    Boolean managed = False;
    Tcl_CmdInfo parentInfo;

    dialog_path = Tm_HiddenParentPath(path);
    if (dialog_path == NULL) {
	        Tcl_AppendResult(interp, "Bad window path name \"", path,
                "\"", (char *) NULL);
        return TCL_ERROR;
    }

    parent = Tm_ParentWidgetFromPath (interp, path);
    if (parent == NULL)
	return TCL_ERROR;

    if (argc >= 3 && strcmp(argv[2], "managed") == 0) {
        managed = True;
        argv++;
        argc--;
    }

    DivideArgs(argv + 2, argc - 2, parent_argv, &num_parent_argc,
                        child_argv, &num_child_argc);

    if (strcmp(command, BulletinBoardDialog) == 0) {
	class = xmBulletinBoardWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateBulletinBoardDialog (parent,
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, FileSelectionDialog) == 0) {
	class = xmFileSelectionBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateFileSelectionDialog (parent,
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, FormDialog) == 0) {
	class = xmFormWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateFormDialog (parent,
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, ErrorDialog) == 0) {
	class = xmMessageBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateErrorDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else 
    if (strcmp(command, InformationDialog) == 0) {
	class = xmMessageBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateInformationDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, MessageDialog) == 0) {
	class = xmMessageBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateMessageDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, QuestionDialog) == 0) {
	class = xmMessageBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateQuestionDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, WarningDialog) == 0) {
	class = xmMessageBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateWarningDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, WorkingDialog) == 0) {
	class = xmMessageBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateWorkingDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, PromptDialog) == 0) {
	class = xmSelectionBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreatePromptDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, SelectionDialog) == 0) {
	class = xmSelectionBoxWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
	new = XmCreateSelectionDialog (parent, 
			Tm_NameFromPath(path), args, num_args);
    } else {
	return TCL_ERROR;
    }

    Tm_SetValues(path, interp, new, parent, class,
                                child_argv, num_child_argc, args, &num_args);
    XtSetValues(new, args, num_args);


    if (managed) {
        XtManageChild (new);
    }

    /* set up dialog parent */

    wPtr = (Tm_Widget *) XtMalloc (sizeof (Tm_Widget));
    wPtr -> interp = interp;
    wPtr -> widget = XtParent(new);
    wPtr -> pathName = dialog_path;
    wPtr -> parent = Tm_ParentPath(path);
    wPtr -> dropProc = NULL;

    Tcl_GetCommandInfo(interp, wPtr->parent, &parentInfo);
    wPtr -> displayInfo = ((Tm_Widget *) parentInfo.clientData)->displayInfo;

    Tm_StoreWidgetInfo(dialog_path, wPtr, interp);
    XtVaSetValues(XtParent(new), XmNuserData, wPtr, NULL);

    Tcl_CreateCommand (interp, dialog_path, Tm_AnyWidgetCmd,
		 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(XtParent(new), XmNdestroyCallback, Tm_DestroyWidgetHandler,
	(XtPointer) wPtr);

    /* set up child */

    wPtr = (Tm_Widget *) XtMalloc (sizeof (Tm_Widget));
    wPtr -> interp = interp;
    wPtr -> widget = new;
    wPtr -> pathName = XtNewString(path);
    wPtr -> parent = dialog_path;
    wPtr -> dropProc = NULL;
    wPtr -> displayInfo = ((Tm_Widget *) parentInfo.clientData)->displayInfo;

    Tm_StoreWidgetInfo(path, wPtr, interp);
    XtVaSetValues(new, XmNuserData, wPtr, NULL);

    Tcl_CreateCommand (interp, path, Tm_AnyWidgetCmd,
		 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(new, XmNdestroyCallback, Tm_DestroyWidgetHandler,
	(XtPointer) wPtr);

    /* create commands for all SelectionBox children */

    if (class == xmSelectionBoxWidgetClass) {
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_APPLY_BUTTON, "Apply");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_CANCEL_BUTTON, "Cancel");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_HELP_BUTTON, "Help");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_LIST, "ItemsList");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_LIST_LABEL, "Items");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_OK_BUTTON, "OK");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_SELECTION_LABEL, "Selection");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_SEPARATOR, "Separator");
	SelectionBoxCreateChild(interp, path, new, XmDIALOG_TEXT, "Text");
    } else

    if (class == xmMessageBoxWidgetClass) {
	MessageBoxCreateChild(interp, path, new, XmDIALOG_CANCEL_BUTTON, "Cancel");
	MessageBoxCreateChild(interp, path, new, XmDIALOG_HELP_BUTTON, "Help");
	MessageBoxCreateChild(interp, path, new, XmDIALOG_MESSAGE_LABEL, "Message");
	MessageBoxCreateChild(interp, path, new, XmDIALOG_OK_BUTTON, "OK");
	MessageBoxCreateChild(interp, path, new, XmDIALOG_SEPARATOR, "Separator");
	MessageBoxCreateChild(interp, path, new, XmDIALOG_SYMBOL_LABEL, "Symbol");
    } else

    if (class == xmFileSelectionBoxWidgetClass) {
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_APPLY_BUTTON, "Apply");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_CANCEL_BUTTON, "Cancel");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_DIR_LIST, "DirList");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_DIR_LIST_LABEL, "Dir");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_FILTER_LABEL, "FilterLabel");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_FILTER_TEXT, "FilterText");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_HELP_BUTTON, "Help");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_LIST, "ItemsList");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_LIST_LABEL, "Items");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_OK_BUTTON, "OK");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_SELECTION_LABEL, "Selection");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_SEPARATOR, "Separator");
	FileSelectionBoxCreateChild(interp, path, new, XmDIALOG_TEXT, "Text");

	return TCL_OK;
    }
    interp -> result = wPtr -> pathName;
    return TCL_OK;
}


/*
 *--------------------------------------------------------------
 *
 * Tm_ScrolledCmd --
 *
 *	This procedure is invoked to process the "scrolled..."
 *	Tcl command.  See the
 *	user documentation for details on what it does.
 *	These create a hiddne parent, which is the ScrolledWindow
 *	
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

/* 
A scrolled widget differs form an ordinary one in that
it is actually two widgets, the scrolled window and
the widget. In this implementation, both must be
visible in the path
	scrolledList <parent>.sw.list
*/
int
Tm_ScrolledCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{

    register Tm_Widget *wPtr;
    Widget new, parent;
    char *command = argv[0];
    char *path = argv[1];
    char *sw_path;
    Arg args[TM_MAXARGS];
    int num_args;
    char *parent_argv[TM_MAXARGS], *child_argv[TM_MAXARGS];
    int num_parent_argc, num_child_argc;
    Tm_WidgetCmdProc widgetCmdProc;
    Boolean managed = False;
    WidgetClass class;
    Tcl_CmdInfo parentInfo;
 
    widgetCmdProc = (Tm_WidgetCmdProc) clientData;

    sw_path = Tm_HiddenParentPath(path);
    if (sw_path == NULL) {
	        Tcl_AppendResult(interp, "Bad window path name \"", path,
                "\"", (char *) NULL);
        return TCL_ERROR;
    }

    parent = Tm_ParentWidgetFromPath (interp, path);
    if (parent == NULL) {
	XtFree(sw_path);
	return TCL_ERROR;
    }

    if (argc >= 3 && strcmp(argv[2], "managed") == 0) {
        managed = True;
        argv++;
        argc--;
    }

    DivideArgs(argv + 2, argc - 2, parent_argv, &num_parent_argc,
                        child_argv, &num_child_argc);

    if (strcmp(command, ScrolledList) == 0) {
	class = xmListWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
        new = XmCreateScrolledList (parent,
			Tm_NameFromPath(path), args, num_args);
    } else
    if (strcmp(command, ScrolledText) == 0) {
	class = xmTextWidgetClass;
        XtInitializeWidgetClass(class);
        Tm_SetValues(path, interp, parent, parent, class,
				parent_argv, num_parent_argc, args, &num_args);
        new = XmCreateScrolledText (parent, Tm_NameFromPath(path), args, num_args);
    } else {
	return TCL_ERROR;
    }

    Tm_SetValues(path, interp, new, parent, class,
                                child_argv, num_child_argc, args, &num_args);
    XtSetValues(new, args, num_args);

    if (managed) {
        XtManageChild (new);
    }


    /* set up scrolled window parent */

    wPtr = (Tm_Widget *) XtMalloc (sizeof (Tm_Widget));
    wPtr -> interp = interp;
    wPtr -> widget = XtParent(new);
    wPtr -> pathName = sw_path;
    wPtr -> parent = Tm_ParentPath(path);
    wPtr -> dropProc = NULL;

    Tcl_GetCommandInfo(interp, wPtr->parent, &parentInfo);
    wPtr -> displayInfo = ((Tm_Widget *) parentInfo.clientData)->displayInfo;

    Tm_StoreWidgetInfo(sw_path, wPtr, interp);
    XtVaSetValues(XtParent(new), XmNuserData, wPtr, NULL);

    Tcl_CreateCommand (interp, sw_path, Tm_AnyWidgetCmd,
		 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(XtParent(new), XmNdestroyCallback, Tm_DestroyWidgetHandler,
	(XtPointer) wPtr);

    /* set up list/text widget */

    wPtr = (Tm_Widget *) XtMalloc (sizeof (Tm_Widget));
    wPtr -> interp = interp;
    wPtr -> widget = new;
    wPtr -> pathName = XtNewString(path);
    wPtr -> parent  = sw_path;
    wPtr -> dropProc = NULL;
    wPtr -> displayInfo = ((Tm_Widget *) parentInfo.clientData)->displayInfo;

    Tm_StoreWidgetInfo(path, wPtr, interp);
    XtVaSetValues(new, XmNuserData, wPtr, NULL);

    Tcl_CreateCommand (interp, path, widgetCmdProc,
		 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(new, XmNdestroyCallback, Tm_DestroyWidgetHandler,
	(XtPointer) wPtr);

    interp -> result = wPtr -> pathName;
    return TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_RowColumnCmd --
 *
 *	This procedure is invoked to process the "rowColumn",
 *	"menuBar" and "pulldownMenu" Tcl commands.  See the
 *	user documentation for details on what it does.
 *	RowCol has lots of convenience creation functions
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */

/* ARGSUSED */
int
Tm_RowColumnCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{
    char *command = argv[0];
    register Tm_Widget *wPtr;
    Widget new, parent;
    char *path = argv[1];
    Arg args[TM_MAXARGS];
    int num_args;
    char *parent_argv[TM_MAXARGS], *child_argv[TM_MAXARGS];
    int num_parent_argc, num_child_argc;
    Boolean managed = False;
    Tcl_CmdInfo parentInfo;

    parent = Tm_ParentWidgetFromPath (interp, path);
    if (parent == NULL)
	return TCL_ERROR;

    if (argc >= 3 && strcmp(argv[2], "managed") == 0) {
        managed = True;
        argv++;
        argc--;
    }

    /* make sure class is initialized before using XtConvertAndStore */
    XtInitializeWidgetClass(xmRowColumnWidgetClass);

    DivideArgs(argv + 2, argc - 2, parent_argv, &num_parent_argc,
                        child_argv, &num_child_argc);

    Tm_SetValues(path, interp, parent, parent, xmRowColumnWidgetClass,
				parent_argv, num_parent_argc, args, &num_args);
    if (strcmp(command, RowColumn) == 0) {
        new = XmCreateRowColumn (parent,
			Tm_NameFromPath(path), args, num_args);
    } else 
    if (strcmp(command, MenuBar) == 0) {
	new = XmCreateSimpleMenuBar(parent, 
			Tm_NameFromPath(path), args, num_args);
    } else 
    if (strcmp(command, PulldownMenu) == 0) {
	new = XmCreatePulldownMenu(parent, 
			Tm_NameFromPath(path), args, num_args);
    } else {
	sprintf(interp->result, "Unknown RowColumn creation command %s\n",
			command);
	return TCL_ERROR;
    }
    Tm_SetValues(path, interp, new, parent, xmRowColumnWidgetClass,
                                child_argv, num_child_argc, args, &num_args);
    XtSetValues(new, args, num_args);

    if (managed) {
        XtManageChild (new);
    }

    wPtr = (Tm_Widget *) XtMalloc (sizeof (Tm_Widget));
    wPtr -> interp = interp;
    wPtr -> widget = new;
    wPtr -> pathName = XtNewString(path);
    wPtr -> parent = Tm_ParentPath(path);
    wPtr -> dropProc = NULL;

    Tcl_GetCommandInfo(interp, wPtr->parent, &parentInfo);
    wPtr -> displayInfo = ((Tm_Widget *) parentInfo.clientData)->displayInfo;

    Tm_StoreWidgetInfo(path, wPtr, interp);
    XtVaSetValues(new, XmNuserData, wPtr, NULL);

    Tcl_CreateCommand (interp, path, Tm_AnyWidgetCmd,
		 (ClientData) wPtr, (void (*) ()) NULL);

    XtAddCallback(new, XmNdestroyCallback, Tm_DestroyWidgetHandler,
	(XtPointer) wPtr);

    interp -> result = wPtr -> pathName;
    return TCL_OK;
}
