#! tiv

proc createPopup {name inside} {
	xmFormDialog $name

	if {[catch $inside area] != 2} {
		error "Error while evaluating $inside" $area
	}

	$area manageChild
	xmSeparator $name.Separator managed
	xmPushButton $name.OK managed -background green
	xmPushButton $name.Cancel managed -background red

	$area setValues \
		-topAttachment attach_form \
		-leftAttachment attach_form \
		-rightAttachment attach_form \
		-bottomAttachment attach_widget -bottomWidget $name.Separator

	$name.Separator setValues \
		-leftAttachment attach_form \
		-rightAttachment attach_form \
		-bottomAttachment attach_widget -bottomWidget $name.OK

	$name.OK setValues \
		-leftAttachment attach_form \
		-bottomAttachment attach_form

	$name.Cancel setValues \
		-leftAttachment attach_widget -leftWidget $name.OK \
		-leftOffset 20 \
		-bottomAttachment attach_form

	$name.OK     activateCallback "set $name.exitFlag 1"
	$name.Cancel activateCallback "set $name.exitFlag 0"
}

proc doModalPopup {name} {
	global $name.exitFlag
	set $name.exitFlag -1

	$name setValues -dialogStyle dialog_full_application_modal
	$name manageChild

	while {[eval set $name.exitFlag] == -1} {
		. processEvent
	}
	$name unmanageChild

	return [set $name.exitFlag]
}
