/******************************************************************************
*                                                                             *
* Copyright (c) 1990,							      *
* 	National Center for Atmospheric Research                              *
*									      *
*******************************************************************************
                                                                               
$Header: /net/src3/btcl/tclTCP2.1/src/RCS/localTypes.h,v 1.2 1994/07/12 20:59:33 vanandel Exp $

*******************************************************************************
* Revision history:
* $Log: localTypes.h,v $
 * Revision 1.2  1994/07/12  20:59:33  vanandel
 * protect NULL against redefinition
 *
 * Revision 1.1  1994/03/09  18:46:39  vanandel
 * Initial revision
 *
 * Revision 1.6  1992/05/12  04:03:58  jose
 * must used numeric for EXPORT_VARS IMPORT_VARS
 *
 * Revision 1.5  1992/05/12  03:54:36  jose
 * added EXPORT_VARS IMPORT_VARS
 *
 * Revision 1.4  1991/03/06  21:36:28  jose
 * added UCHAR
 *
 * Revision 1.3  91/01/14  19:08:49  jose
 * added GLOBAL #define
 * 
 * Revision 1.2  90/12/31  12:50:25  jose
 * added NULLPTR define.
 * 
 * Revision 1.1  90/02/08  09:43:18  gagnon
 * Initial revision
 * 
* 
*********************************END OF RCS INFO******************************/


/* this header file is designed to be included by programs compiled for Unix
 * it defines the most of same types and defines as /vx/h/vxWorks.h,
 * but keeps us from having to search /vx/h for all other include files,
 * which causes type collisions with the standard unix definitions
 */
#ifndef INCRadarTypes
#define INCRadarTypes

#ifndef NULL	
#define NULL		0
#endif

#if	!defined(NULLPTR)
#define         NULLPTR         ((char *)NULL)
#endif

#if	!defined(EOF) || (EOF!=(-1))
#define EOF		(-1)
#endif

#if	!defined(FALSE) || (FALSE!=0)
#define FALSE		0
#endif

#if	!defined(TRUE) || (TRUE!=1)
#define TRUE		1
#endif


#define NONE		(-1)	/* for times when NULL won't do */
#define EOS		'\0'	/* C string terminator */


/* return status values */

#define OK		0
#define ERROR		(-1)

/* low-level I/O input, output, error fd's */

#define	STD_IN	0
#define	STD_OUT	1
#define	STD_ERR	2

/* modes - must match O_RDONLY/O_WRONLY/O_RDWR in ioLib.h! */

#define READ		0
#define WRITE		1
#define UPDATE		2

/* SYSTEM types */

#define V7		1	/* ATT version 7 */
#define SYS_V		2	/* ATT System 5 */
#define BSD_4_2		3	/* Berkeley BSD 4.2 */


/* macros */

#define MSB(x)	(((x) >> 8) & 0xff)	/* most signif byte of 2-byte integer */
#define LSB(x)	((x) & 0xff)		/* least signif byte of 2-byte integer*/

#define OFFSET(structure, member)	/* byte offset of member in structure*/\
		((int) &(((structure *) 0) -> member))

#define MEMBER_SIZE(structure, member)	/* size of a member of a structure */\
		(sizeof (((structure *) 0) -> member))

#define NELEMENTS(array)		/* number of elements in an array */ \
		(sizeof (array) / sizeof ((array) [0]))

#define FOREVER	for (;;)

#define max(x, y)	(((x) < (y)) ? (y) : (x))
#define min(x, y)	(((x) < (y)) ? (x) : (y))


/* type definitions */

#define FAST	register
#define IMPORT	extern
#define LOCAL	static
#define GLOBAL
#define EXPORT_VARS 2
#define IMPORT_VARS 3

/* The following stuff must NOT be included if this include file is used
 * from assembly language.  Just #define ASMLANGUAGE before the include,
 * to get rid of it. */

#ifndef ASMLANGUAGE

typedef int (*FUNCPTR) ();		/* pointer to a function */

typedef char TINY;
typedef char TBOOL;
typedef unsigned char UTINY;
typedef unsigned char UCHAR;
typedef unsigned short USHORT;
typedef unsigned int UINT;
typedef unsigned long ULONG;
typedef int ARGINT, BOOL, VOID, STATUS;
typedef unsigned short INSTR;		/* word-alligned instructions */

#endif ASMLANGUAGE

#endif INCRadarTypes
