/*
 * Copyright 1987-1991 Regents of the University of California
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */
/*
 * Copyright 1992 by the National Optical Astronomy Observatories(*)
 *
 * Permission to use, copy, and distribute
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * This software is provided "as is" without any express or implied warranty.
 *
 * (*) Operated by the Association of Universities for Research in
 *     Astronomy, Inc. (AURA) under cooperative agreement with the
 *     National Science Foundation.
 */
/* Program: tclmain.c
 *      This file contains an OLIT test program that uses the tclipc library.
 *
 * Created: K. Gillies 26 June 1992
 *
 * SCCS INFO
 *      %W% %G%
 */
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include "tcl.h"
#include "tclipc.h"

#define TRUE 1
#define FALSE 0

/* Something I use to reduce length of arg lists */
typedef struct _tclInfo {
  Tcl_Interp *interp;
  Tcl_CmdBuf buffer;
} tclinfo, *tclInfo;
static tclInfo info;

/* Save information about the senders */
typedef struct _ipcSenderInfo {
  char *program;
  char *handleName;
  Sender sender;
} ipcSenderInfo;

/* In file function prototypes */
static int cmdQuit _ANSI_ARGS_((ClientData *clientData, Tcl_Interp *interp, 
				int argc, char *argv[]));
static int cmdBeep _ANSI_ARGS_((ClientData *clientData, Tcl_Interp *interp, 
				int argc, char *argv[]));
static tclInfo tclInit _ANSI_ARGS_((void));
static evalcmd_res* tclTestCmdReceive _ANSI_ARGS_((Tcl_Interp *interp, 
						   cmdText cmd));
static void SocketInputCallback _ANSI_ARGS_ ((caddr_t clientData, 
                                int *source,
				XtInputId *id));
static void xtRegisterNewFD _ANSI_ARGS_((int newfd));
static void xtUnRegisterFD _ANSI_ARGS_ ((int dyingfd));

#define MYBUFSIZ        64
/* Some variables */
#if defined(__STDC__)
static volatile int quitFlag = FALSE;
#else
static int quitFlag = FALSE;
#endif
static int input_id;
static XtAppContext thisApp;

/* Some structures for save sender information */
/* This is just a demo! */
#define RECSIZE 24
#define EMPTY -1
struct _cdata {
  int fd;
  XtInputId inputID;
} inputdata[RECSIZE];

char *initCmd =
 "if [file exists [info library]/init.tcl] {source [info library]/init.tcl}";

/*
 *--------------------------------------------------------------
 *
 * olitipcInit
 *
 *      A special initialization for the OLIT test program.
 *
 * Results:
 *      TCL_ERROR or TCL_OK
 *--------------------------------------------------------------
 */
int olitipcInit(app, appName)
XtAppContext app;
char *appName;
{
  Receiver result;
  int i;

  /* Init an interpreter */
  info = tclInit();
  /* Init the send library */
  /* A special command responder and connection functions */
  ipcSendInit(0, 0, 0, 0, 
	      tclTestCmdReceive, NULL, 
	      xtRegisterNewFD, xtUnRegisterFD);
  ipcInterpInit(info->interp);
  /* Set this global first */
  thisApp = app;

  /* Initialze some temp stuff */
  for (i=0; i<RECSIZE; i++) {
    inputdata[i].fd = EMPTY;
    inputdata[i].inputID = (XtInputId)EMPTY;
  }
  /* Set up a receiver for the program */
  result = ipcNewReceiver(info->interp, appName, "localhost");
  if (result == NULL) {
    fprintf(stderr, "Could not register program receiver.  Exiting...\n");
    exit(-1);
  }
  return (result == NULL) ? TCL_ERROR : TCL_OK;
}

/*
 *--------------------------------------------------------------
 *
 * xtRegisterNewFD
 *
 *      Setup to listen for events on a new file desciptor.
 *
 * Results:
 *      void
 *--------------------------------------------------------------
 */
static void xtRegisterNewFD(newfd)
int newfd;
{
  register int i;
  int input_id;

  input_id = XtAppAddInput(thisApp,
			   newfd,
			   (XtPointer)XtInputReadMask,
			   SocketInputCallback,
			   (caddr_t)NULL);
  /* Save the pair for later removal */
  for (i=0; i<RECSIZE; i++) {
    if (inputdata[i].fd == EMPTY) {
      inputdata[i].fd = newfd;
      inputdata[i].inputID = input_id;
#ifdef DEBUG
      fprintf(stderr, "Add array: %d, fd: %d, ID: %ld\n", i, newfd, input_id);
#endif
      return;
    }
  }
  fprintf(stderr, "Too many receivers!  Only %d are allowed in the demo.\n",
	  RECSIZE-1);
}

/*
 *--------------------------------------------------------------
 *
 * xtUnRegisterFD
 *
 *      Remove the information for a connection.
 *
 * Results:
 *      void
 *--------------------------------------------------------------
 */
static void xtUnRegisterFD(dyingfd)
int dyingfd;
{
  register int i;

  for (i=0; i<RECSIZE; i++) {
    if (inputdata[i].fd == dyingfd) {
      XtRemoveInput(inputdata[i].inputID);
#ifdef DEBUG
      fprintf(stderr, "Removed array: %d fd: %d inputid: %d.\n", 
	      i, dyingfd, inputdata[i].inputID);
#endif
      inputdata[i].fd = EMPTY;
      inputdata[i].inputID = EMPTY;
      return;
    }
  }
  fprintf(stderr, "Could not find fd: %d.\n", dyingfd);
}

/*
 *--------------------------------------------------------------
 *
 * SocketInputCallback
 *
 *      Function called when data arrives on a particular fd 
 *
 * Results:
 *      void
 *--------------------------------------------------------------
 */
static void SocketInputCallback(clientData, source, id)
caddr_t clientData;
int *source;
XtInputId *id;
{
  register int i;
  int fd = -1;

  /* Look for the fd associated with id */
  for (i=0; i<RECSIZE; i++) {
    if (inputdata[i].inputID == *id) {
      fd = inputdata[i].fd;
      break;
    }
  }
#ifdef DEBUG
  fprintf(stderr, "request array: %d input: %d fd: %d callback\n", 
	  i, *id, fd);
#endif
  /* Receive one even on the fd */
  ipcListenOnceOnSocket(fd); 
}

/*
 *--------------------------------------------------------------
 *
 * olitAddSender
 *
 *      Add data for a new sender.  Called from OLIT callback.
 *
 * Results:
 *      the new handle
 *--------------------------------------------------------------
 */
char *olitAddSender(senderName)
char *senderName;
{
  Sender newSender;
  ipcSenderInfo *new;

  /* Create a new sender */
  newSender = ipcNewSender (info->interp, 
			    senderName,
			    ANYHOST, LOCALHOST); 
  assert(newSender != (Sender)NULL);

  /* Allocate some new sender data */
  new = (ipcSenderInfo *)malloc(sizeof(ipcSenderInfo));
  assert(new != NULL);
  new->program = strdup(senderName);
  new->handleName = strdup(info->interp->result);
  new->sender = newSender;

  return (char *)new;
}

/*
 *--------------------------------------------------------------
 *
 * olitGetLabel
 *
 *      Return the name of the program
 *
 * Results:
 *      The name of the program.
 *--------------------------------------------------------------
 */
char *olitGetLabel(ipcinfo)
ipcSenderInfo *ipcinfo;
{
  return ipcinfo->program;
}

/*
 *--------------------------------------------------------------
 *
 * xoipcSend
 *
 *      Send a command and return the results in the given
 *      interpreter.
 *
 * Results:
 *      result string
 *--------------------------------------------------------------
 */
char *xoipcSend(ipcinfo, command)
ipcSenderInfo *ipcinfo;
char *command;
{
  assert(ipcinfo->sender != NULL);

  return (ipcRemoteSend(ipcinfo->sender, "%s", command) == TCL_OK) ?
          info->interp->result : "Message send failed!\n";
    
}

/*
 *--------------------------------------------------------------
 *
 * tclTestCmdReceive
 *
 *      A test command receive function
 *
 * Results:
 *      the results
 *--------------------------------------------------------------
 */
static evalcmd_res* tclTestCmdReceive(interp, argp)
Tcl_Interp *interp;
cmdText argp;
{
  static evalcmd_res answer = { 0, NULL };
  extern void olitShowString _ANSI_ARGS_((char*, char*));

  /* Only free after the first time */
  if (answer.text != NULL) {
    free((char *)answer.text);
  }
  printf(">>Test\n");
  answer.errno = Tcl_Eval(interp, argp, 0, NULL);
  answer.text = interp->result;
  olitShowString(argp, answer.text);
  return(&answer);
}

/*
 *--------------------------------------------------------------
 *
 * olitDoQuit
 *
 *      A special quit that deletes references to us.
 *
 * Results:
 *      void
 *--------------------------------------------------------------
 */

void olitDoQuit()
{
  ipcDestroyAll(info->interp);

  Tcl_DeleteInterp(info->interp);
  Tcl_DeleteCmdBuf(info->buffer);
  exit(0);
}

static tclInfo tclInit()
{
  int result;
  tclInfo info;

  info = (tclInfo)malloc(sizeof(tclinfo));
  assert(info != NULL);

  info->interp = Tcl_CreateInterp();

  /* Some standard tcl built-ins */
  Tcl_CreateCommand(info->interp, "quit", (Tcl_CmdProc *)cmdQuit,
                    (ClientData) 0,
                    (Tcl_CmdDeleteProc *) NULL);

  Tcl_CreateCommand(info->interp, "beep", (Tcl_CmdProc *)cmdBeep,
                    (ClientData) 0,
                    (Tcl_CmdDeleteProc *) NULL);

  info->buffer = Tcl_CreateCmdBuf();

  /* Source the tcl library */
  result = Tcl_Eval(info->interp, initCmd, 0, (char **) NULL);
  assert(result == TCL_OK);

  return info;
}

static int cmdQuit(clientData, interp, argc, argv)
ClientData *clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  quitFlag = 1;
  return TCL_OK;
}

/* A beep command */
static int cmdBeep(clientData, interp, argc, argv)
ClientData *clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  /* FakeButtonPress("Test"); */
  Tcl_AppendResult(interp, "OK", (char *)NULL);
  return TCL_OK;
}
