/*
 * Collections:
 *
 * Simple linked lists of things, with an add, a delete operation, a foreach
 * operation, and a size operation.
 * SCCS INFO
 * %W% %G%
 */
#include "collection.h"
#include <sys/stdtypes.h>

#ifndef NULL
#define NULL 0L
#endif

static status allocate_node(c, data)
Collection *c;
generic_ptr data;
{
  Collection C = (Collection) malloc(sizeof *C);

  if (C == NULL)
    return ERROR;

  *c = C;
  CDATA(C) = data;
  NEXT(C) = NULL;
  return NOERROR;
}

static void free_node(c)
Collection *c;
{
  free(*c);
  *c = NULL;
}

status CollectionCreate(c)
Collection *c;
{
  Collection p;

  if (allocate_node(&p, NULL) == ERROR) return ERROR;
  *c = p;

  return NOERROR;
}

void CollectionDestroy(c, p_func_f)
Collection c;
void (*p_func_f)();
{
  Collection first, next;

  if (c == NULL) return;
    if (CollectionEmpty(c)) {
      free_node(&c);
    return;
  }

  first = NEXT(c);
  NEXT(c) = NULL;

  while (first != NULL) {
    next = NEXT(first);
    if (p_func_f != NULL)
      (*p_func_f)(CDATA(first));
    free_node(&first);
    first = next;
  }
  free_node(&c);
}

status CollectionAdd(c, info)
register Collection c;
generic_ptr info;
{
  Collection temp;

  /* passed NULL */
  if (c == NULL) return ERROR;
  if (allocate_node(&temp, info) == ERROR) return ERROR;

  NEXT(temp) = NEXT(c);
  NEXT(c) = temp;
  return NOERROR;
}

status CollectionAppend(c, info)
register Collection c;
generic_ptr info;
{
  Collection newnode, temp;

  if (allocate_node(&newnode, info) == ERROR) return ERROR;
	
  if (CollectionEmpty(c))
    NEXT(c) = newnode;
  else {
    for (temp = NEXT(c); NEXT(temp) != NULL; temp = NEXT(temp));
      NEXT(temp) = newnode;
  }
  return NOERROR;
}
  
status CollectionDeleteFirst(c, info)
register Collection c;
generic_ptr *info;
{
  if (c == NULL || CollectionEmpty(c)) return ERROR;

  *info = CDATA(NEXT(c));
  return CollectionDelete(c, NEXT(c));
}

status CollectionDelete(c, node)
register Collection c;
Collection node;
{
  register Collection temp;

  if (c == NULL || CollectionEmpty(c)) return ERROR;

  temp = NEXT(c);
  if (temp == node)  	/* first */
    NEXT(c) = NEXT(temp);
  else {
    for (temp = NEXT(c); temp != NULL && NEXT(temp) != node; temp = NEXT(temp));
      if (temp == NULL)
	return ERROR;
      else
	NEXT(temp) = NEXT(node);
  }
  free_node(&node);
  return NOERROR;
}

status CollectionFind(c, key, p_cmp_f, keynode)
register Collection c;
generic_ptr key;
int (*p_cmp_f)();
Collection *keynode;
{
  register Collection temp = NULL;

  if (c == NULL || CollectionEmpty(c)) return ERROR;

  for (temp = NEXT(c); temp != NULL; temp = NEXT(temp)) {
    if ((*p_cmp_f)(key, CDATA(temp)) == 0) {
      *keynode = temp;
      return NOERROR;
    }
  }
  return ERROR;
}

int CollectionSize(c)
Collection c;
{
  register Collection temp;
  register int size;

  if (c == NULL) return 0;

  for (size = 0, temp = NEXT(c); temp != NULL; temp = NEXT(temp), size++) ;
  return size;
}
