/*
 * tclExtdInt.h
 *
 * Standard internal include file for Extended Tcl library..
 *---------------------------------------------------------------------------
 * Copyright 1991 Karl Lehenbauer and Mark Diekhans.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Karl Lehenbauer and
 * Mark Diekhans make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

#ifndef TCLEXTDINT_H
#define TCLEXTDINT_H

#include "tclExtend.h"
#include "tclInt.h"
#include "tclUnix.h"

#include <values.h>
#include <grp.h>
/*
 * If sys/times.h was not included by tclUnix.h, then include it.  On some
 * systems, it cann't be double included.
 */
#if TCL_GETTOD
#   include <sys/times.h>
#endif

/*
 * On some systems this is not included by tclUnix.h.
 */
#include <sys/param.h>
#ifndef CLK_TCK
#    ifdef HZ
#        define CLK_TCK HZ
#    else
#        define CLK_TCK 60
#    endif
#endif



#ifndef MAXINT
#    define BITSPERBYTE   8
#    define BITS(type)    (BITSPERBYTE * (int)sizeof(type))
#    define HIBITI        (1 << BITS(int) - 1)
#    define MAXINT        (~HIBITI)
#endif

#ifndef MININT
#    define MININT (-MAXINT)-1
#endif

#ifndef TRUE
#    define TRUE   (1)
#    define FALSE  (0)
#endif

/*
 * Structure to hold a regular expression, plus a Boyer-Moore compiled
 * pattern.
 */

typedef struct regexp_t {
    regexp *progPtr;
    char   *boyerMoorePtr;
    int     noCase;
    } regexp_t;
typedef regexp_t *regexp_pt;
/*
 * Flags used by RegExpCompile:
 */
#define REXP_NO_CASE         1   /* Do matching regardless of case    */
#define REXP_BOTH_ALGORITHMS 2   /* Use boyer-moore along with regexp */

/*
 * Data structure to control a dynamic buffer.  These buffers are primarly
 * used for reading things from files, were the maximum size is not known
 * in advance, and the buffer must grow.  These are used in the case were
 * the value is not to be returned as the interpreter result.
 */

#define INIT_DYN_BUFFER_SIZE 256

typedef struct dynamicBuf_t {
    char  buf [INIT_DYN_BUFFER_SIZE];   /* Initial buffer area.              */
    char *ptr;                          /* Pointer to buffer area.           */
    int   size;                         /* Current size of buffer.           */
    int   used;                         /* Current amount used, include '\0' */
    } dynamicBuf_t;

/*
 * Macros to do string compares.  They pre-check the first character before
 * checking of the strings are equal.
 */

#define STREQU(str1, str2) \
        ((str1[0] == str2[0]) && (strcmp (str1, str2) == 0))
#define STRNEQU(str1, str2, cnt) \
        ((str1[0] == str2[0]) && (strncmp (str1, str2, cnt) == 0))

void
Tcl_DynBufInit _ANSI_ARGS_((dynamicBuf_t *dynBufPtr));

void
Tcl_DynBufFree _ANSI_ARGS_((dynamicBuf_t *dynBufPtr));

void
Tcl_DynBufReturn _ANSI_ARGS_((Tcl_Interp    *interp,
                              dynamicBuf_t *dynBufPtr));

void
Tcl_DynBufAppend _ANSI_ARGS_((dynamicBuf_t *dynBufPtr,
                              char         *newStr));

int
Tcl_DynamicFgets _ANSI_ARGS_((dynamicBuf_t *dynBufPtr,
                              FILE         *filePtr));

int
Tcl_ConvertFileHandle _ANSI_ARGS_((Tcl_Interp *interp,
                                  char       *handle));

int
Tcl_ProcessSignal _ANSI_ARGS_((Tcl_Interp *interp,
                               int         cmdResultCode));

void
Tcl_RegExpClean _ANSI_ARGS_((regexp_pt regExpPtr));

int
Tcl_RegExpCompile _ANSI_ARGS_((Tcl_Interp  *interp,
                               regexp_pt    regExpPtr,
                               char        *expression,
                               int          flags));

int
Tcl_RegExpExecute _ANSI_ARGS_((Tcl_Interp  *interp,
                               regexp_pt    regExpPtr,
                               char        *matchStrIn,
                               char        *matchStrLower));
void
Tcl_ResetSignals ();

/*
 * Definitions required to initialize all extended commands.  These are either
 * the command executors or initialization routines that do the command
 * initialization.  The initialization routines are used when there is more
 * to initializing the command that just binding the command name to the
 * executor.  Usually, this means initializing some command local data via
 * the ClientData mechanism.
 */

/*
 * from chmod.c
 */
extern Tcl_CmdProc  Tcl_ChmodCmd, Tcl_ChownCmd, Tcl_ChgrpCmd;

/*
 * from clock.c
 */
extern Tcl_CmdProc  Tcl_GetclockCmd, Tcl_FmtclockCmd;

/*
 * from cmdloop.c
 */
extern Tcl_CmdProc  Tcl_CommandloopCmd;

/*
 * from debug.c
 */
void
Tcl_InitDebug _ANSI_ARGS_((Tcl_Interp *interp));

/*
 * from filescan.c
 */
void
Tcl_InitFilescan _ANSI_ARGS_((Tcl_Interp *interp));

/*
 * from fmath.c
 */
extern Tcl_CmdProc  Tcl_AcosCmd, Tcl_AsinCmd, Tcl_AtanCmd,  Tcl_CosCmd,
                    Tcl_SinCmd,  Tcl_TanCmd,  Tcl_CoshCmd,  Tcl_SinhCmd,
                    Tcl_TanhCmd, Tcl_ExpCmd,  Tcl_LogCmd,   Tcl_Log10Cmd,
                    Tcl_SqrtCmd, Tcl_FabsCmd, Tcl_FloorCmd, Tcl_CeilCmd,
                    Tcl_FmodCmd, Tcl_PowCmd;

/*
 * from general.c
 */
extern Tcl_CmdProc  Tcl_EchoCmd, Tcl_InfoxCmd, Tcl_LoopCmd;

/*
 * from id.c
 */
extern Tcl_CmdProc  Tcl_IdCmd;

/*
 * from iocmds.c
 */
extern Tcl_CmdProc  Tcl_BsearchCmd, Tcl_DupCmd, Tcl_PipeCmd, Tcl_CopyfileCmd,
                    Tcl_FstatCmd,   Tcl_FcntlCmd, Tcl_SelectCmd;

/*
 * from list.c
 */
extern Tcl_CmdProc  Tcl_LvarpopCmd, Tcl_LemptyCmd, Tcl_KeyldelCmd,
                    Tcl_KeylgetCmd, Tcl_KeylsetCmd;

/*
 * from math.c
 */
extern Tcl_CmdProc  Tcl_MaxCmd, Tcl_MinCmd, Tcl_RandomCmd;

/*
 * from signal.c
 */
void
Tcl_InitSignalHandling _ANSI_ARGS_((Tcl_Interp *interp));

/*
 * from string.c
 */
extern Tcl_CmdProc  Tcl_CindexCmd,     Tcl_ClengthCmd,   Tcl_CrangeCmd,
                    Tcl_ReplicateCmd,  Tcl_TranslitCmd,  Tcl_CtypeCmd;


/*
 * from unixcmds.c
 */
extern Tcl_CmdProc  Tcl_ExecvpCmd, Tcl_ForkCmd,   Tcl_KillCmd,  Tcl_AlarmCmd,
                    Tcl_SleepCmd,  Tcl_SystemCmd, Tcl_TimesCmd, Tcl_UmaskCmd,
                    Tcl_LinkCmd,   Tcl_UnlinkCmd, Tcl_MkdirCmd, Tcl_RmdirCmd,
                    Tcl_WaitCmd;


#endif
