
/* -*-Mode: C;-*- exec.c -[Mon Oct 12 15:59:50 1992 by cxh]- */
#ifndef lint
static char     rcsid[] = "$Id: sql.sc,v 1.4 1992/09/29 21:20:13 cxh Exp cxh $";
#endif
/*
 * Copyright 1992 Regents of the University of California. Permission to use,
 * copy, modify, and distribute this software and its documentation for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies.  The University of California makes
 * no representations about the suitability of this software for any purpose.
 * It is provided 'as is' without express or implied warranty.
 */

/*
 * This file consists of the sql specific code.  This file contains embedded
 * sql, it should be converted to a .c file by Ingres' esql. The functions at
 * the bottom are externally visible.
 */

#include "tclsql.h"
#include "coltype.h"

/* Include the sql communications area. */
EXEC SQL INCLUDE SQLCA;

/* Include the global data location typdef. */
EXEC SQL INCLUDE SQLDA;

/* curs.h must be included _after_ INCLUDE SQLCA and SQLDA */
#include "curs.h"


/* Non-user defined SQL data area used for SQLselect* commands. */
IISQLDA        *Sqlda = (IISQLDA *) 0;
/*
 * Array of column type structures for Non-user defined SQL data area.
 */
COLTYPE        *Coltype = (COLTYPE *) 0;

/* Set up for traversing the output of a query. */
EXEC SQL DECLARE stmnt STATEMENT;
EXEC SQL DECLARE csr CURSOR FOR stmnt;



/* Execute a select statement, traverse the output. */
static
exec_select(interp, res_var, cmd, op)
     Tcl_Interp     *interp;
     char           *res_var;	/* Name of variable to put results in. */
     char           *cmd;	/* Calling tcl command name. */
     int             op;	/* Operation to be performed. */
{
  int             rows = 0;
  char            row_indice[INDICE_LEN];
  char            col_num[BUFSIZ];
  int		  ncols = 0;
  int		  got_row_n = 0;

  if ((op & (SELECT_COLNAMES | SELECT_COLTYPES)) && (!(op & SELECT_ROW))) {
    if (append_header(interp, res_var, "0", &ncols, op, Sqlda, Coltype) == TCL_ERROR) {
      Tcl_AppendResult(interp, cmd, ": Trouble appending header.", 0);
      return TCL_ERROR;
    }
    sprintf(col_num,"%d",ncols);
    Tcl_SetResult(interp, col_num, TCL_VOLATILE);
  }
  else {
    /* Append one or all of the rows of the select. */
    if (append_header(interp, res_var, "0", &ncols, op, Sqlda, Coltype)) {
      Tcl_AppendResult(interp, cmd, ": Trouble appending header.", 0);
      return TCL_ERROR;
    }

    EXEC SQL WHENEVER SQLERROR GOTO close_csr;
    EXEC SQL OPEN csr FOR READONLY;

    /* Prime row_indice incase there are no rows returned. */
    strcpy(row_indice, "0");

    while (sqlca.sqlcode == 0) {
      EXEC SQL FETCH csr USING DESCRIPTOR:Sqlda;
      if (sqlca.sqlcode == 0) {
	rows++;
	sprintf(row_indice, "%d", rows);
	/* If the op code is one or more, then append the row. */
	if ((op & SELECT_ALL) && (!(op & SELECT_ROW)))
	  append_row(interp, res_var, row_indice, op, Sqlda);
	else if (rows == SelectRow) {
	  got_row_n = 1;
	  append_row(interp, res_var, row_indice, op, Sqlda);
	  break;
	}
      }
    }

  close_csr:
    if (sqlca.sqlcode < 0) {
      sql_error(interp, cmd);
      return TCL_ERROR;
    }
    
    if (op & SELECT_ROW) {
      if (got_row_n == 1)
	sprintf(col_num,"%d",ncols);
      else
	strcpy(col_num, "0");
      Tcl_SetResult(interp, col_num, TCL_VOLATILE);
    } else
      Tcl_SetResult(interp, row_indice,TCL_VOLATILE);

    EXEC SQL WHENEVER SQLERROR CONTINUE;
    EXEC SQL CLOSE  csr;
  }
  return TCL_OK;
}

/*
 * Initialize the statically defined user areas that SQLexec and SQLselect*
 * use.
 */
init_static(interp, cmd)
     Tcl_Interp     *interp;
     char           *cmd;
{
  if (!Sqlda) {
    /* Set up the sql data area */
    if ((Sqlda = init_sqlda(DEFAULT_ELEMENTS)) == NULL) {
      Tcl_AppendResult(interp, cmd, " Could not allocate sql data area. ", 0);
      return TCL_ERROR;
    }
  }

  if (!Coltype) {
    if ((Coltype = init_coltype(DEFAULT_ELEMENTS)) == NULL) {
      Tcl_AppendResult(interp, cmd, " Could not allocate memory for column type data area. ", 0);
      return TCL_ERROR;
    }
  }
  return TCL_OK;
}


/*
 * Free up the statically defined user areas that SQLexec and SQLselect* use.
 */
sql_clean_static()
{
  if (Sqlda) {
    free((char *) Sqlda);
    Sqlda = (IISQLDA *) 0;
  }
  if (Coltype)
    Coltype = free_coltype(Coltype);
}



/*
 * Called by all SQLselect and SQLexec commands.  SQLexec calls this
 * directly. Returns TCL_OK or TCL_ERROR.
 */
exec_sql(interp, res_var, cmd, buf, op)
     Tcl_Interp     *interp;
     char           *res_var;	/* Name of array to place results in. */
     char           *cmd;	/* Name of the calling sql command. */
     char           *buf;	/* Command string. */
     int             op;	/* Code # of operation to perform. (get all
				 * data, get just the header or get row N
				 * etc.) */
{
  EXEC SQL BEGIN DECLARE SECTION;
  char           *cbuf;
  EXEC SQL END DECLARE SECTION;
  /* int			rows; */

  if (init_static(interp, cmd) == TCL_ERROR) {

    return TCL_ERROR;
  }
  cbuf = buf;

  EXEC SQL WHENEVER SQLERROR GOTO stmnt_err;
  EXEC SQL PREPARE stmnt FROM:cbuf;
  EXEC SQL DESCRIBE stmnt INTO:Sqlda;

  /* If there is not enough space, then get a new sqlda. */
  if (Sqlda->sqld > Sqlda->sqln) {
    if (Sqlda)
      free((char *) Sqlda);
    if ((Sqlda = init_sqlda(Sqlda->sqld)) == NULL) {
      Tcl_AppendResult(interp, cmd,
		       "Could not allocate memory for sql data area. ", 0);
      return TCL_ERROR;
    }
    if (Coltype)
      Coltype = free_coltype(Coltype);
    /* Sqlda->sqln has been initialized, but sqlda->sqld will be 0 */
    if ((Coltype = init_coltype(Sqlda->sqln)) == NULL) {
      Tcl_AppendResult(interp, cmd,
		"Could not allocate memory for column type data area. ", 0);
      return TCL_ERROR;
    }

    EXEC SQL DESCRIBE stmnt INTO:Sqlda;


  }

  if (Sqlda->sqld == 0) {
    /* Not a select. */
    EXEC SQL EXECUTE stmnt;
    /* rows = sqlca.sqlerrd[2]; */
    Tcl_SetResult(interp, "",TCL_VOLATILE);
  }
  else {
    return exec_select(interp, res_var, cmd, op);
  }

  return TCL_OK;
stmnt_err:
  EXEC SQL WHENEVER SQLERROR CONTINUE;
  sql_error(interp, cmd);
  return TCL_ERROR;
}				/* exec_sql() */
