#---------------------------------------------------------------------------
#
#	Help Window Creation
#
#---------------------------------------------------------------------------

#---------------------------------------------------------------------------
#
# BEWARE: the "fit" option will give you weird effects!!

defwidget Help

defmethod Help new {name args} {

  args	fit layout {height 20} help {embedded false}

  if { $layout == "" && $embedded != "true" } {
    set layout center
  }

  if { $embedded != "true" } {
    Toplevel new $name -reuse true
    Button new $name.dismiss -layout {bottom padx 10 pady 15} \
	-textfont large -text Dismiss \
	-action [list $name Dismiss]
  } {
    Frame new $name
  }
  defsuper $name Help

  set topic [lindex $help 0]
  set values [lrange $help 1 end]

  if { [set file [_check(file) Help $topic.help -]] != "-" } {
    set init Formatted
  } elseif { [set file [_check(file) Help $topic.text -]] != "-" } {
    set init Text
  } elseif { [set file [_check(file) Help .help -]] != "-" } {
    set init Formatted
    set values [list $topic]
  } {
    set init List
    set file [list "Help for '$topic' is not available." {largebold 0.0 end}]
  }
  Textedit new $name.help -embedded true -readonly true -height $height \
	-initmethod $init -init $file -layout {top} -values $values

  $name layout $layout
}

Window addDemo Help

defmethod Help demo {} {

  Help new * -help Library/printers -layout +100+100
}
