
#---------------------------------------------------------------------------

defwidget Inputbox

defmethod Inputbox new {name args} {
  global data

  args	{width 24} text label {fit false} edittext {layout center} \
	{textfont text} {labelfont bold} {input safe} max {relief flat} \
	{title {Enter a New Value}} info {infofont text} {actions {Ok Help}}

  set actions [$self buildActions $actions $name]
  Toplevel new $name -title $title -transient true \
	-handler $name -buttons {Ok Help} -actions $actions
  $name decorate
  defsuper $name Inputbox

  if { $info != {} } {
    Message new *$name -layout {padx 10 pady 10 expand fill} \
	-text $info -textfont $infofont
  }

  set data($name) $text
  Inputline new $name.in -width $width -text $text -label $label -fit $fit \
	-edittext $edittext -layout {bottom frame center padx 20 pady 20} \
	-labelfont $labelfont -input $input -max $max -relief $relief \
	-textfont $textfont -action [list $name Ok]
  $name layout $layout
  $name timeoutGrab

  tkwait window $name

  set text $data($name)
  unset data($name)
  return $text
}

defmethod Inputbox Help {arg} {

  if { $arg == {} } {
    set arg Library/inputbox
  }
  $self Help $arg
}

defmethod Inputbox Ok {ignore} {
  global data

  set data($self) [$self.in get]
  $self Dismiss
}

Window addDemo Inputbox

defmethod Inputbox demo {} {

  set result \
	[Inputbox new * -text "Text " -label "Type here:" -edittext true \
	  -layout center -info "The value your have specified is not valid. \
Try again. Check the user manual of the system if you are not sure about \
which values may be entered at this point. Well, I had to write something \
here. This is a rather silly text but it illustrates the principle."]
  puts stdout "Inputbox: $result"
}
