#---------------------------------------------------------------------------
#
#	Input Line Creation
#
#---------------------------------------------------------------------------

defwidget Inputline

defmethod Inputline new {name args} {

  args	{width 24} text label action {fit false} edittext layout \
	{textfont text} {labelfont bold} {input safe} max {relief flat}

  Frame new $name -layout $layout -relief $relief
  defsuper $name Inputline
  set action [$name buildAction $action]

  if { [position $input {number positive safe any}] < 0 } {
    set input any
  }

  if { $edittext == "true" } then {

    Label new ${name}.label \
	-layout {left fillx frame nw padx 5 pady 5} \
	-relief flat -text "${label}" -fit true -textfont $labelfont
    Scrollbar new $name.scroll -layout {right filly} \
	-dir vertical -action "$name.entry! yview"
    Text new $name.entry -textfont $textfont -relief sunken \
	-width $width -height 3 -wrap char \
	-yscroll "$name.scroll! set" \
	-layout {left} -text $text -state normal \
	-action $action -max $max -filter [list $name _$input]

  } else {

    Label new $name.label -layout {left padx 4 pady 4} \
	-text $label -fit $fit \
	-relief flat -textfont $labelfont
    Entry new $name.entry -layout {left padx 4 pady 4 fillx} \
	-textfont $textfont -width $width -text $text \
	-action $action -max $max -filter [list $name _$input]

  }

  focus $name.entry
  return $name
}

defmethod Inputline entry {} {

  return $self.entry
}

defmethod Inputline get {} {

  $self.entry get
}

defmethod Inputline set {value} {

  $self.entry set $value
}

defmethod Inputline _init {} {
  global _Inputline

  foreach i {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
	     a b c d e f g h i j k l m n o p q r s t u v w x y z
	     0 1 2 3 4 5 6 7 8 9 + - , . & ( ) =} {
   set _Inputline($i) 1
  }
}

Inputline _init

defmethod Inputline _safe {key} {
  global _Inputline

  if { $key != " " && ![info exists _Inputline($key)] } {
    return
  }
  $self _any $key
}

defmethod Inputline _number {key} {

  if { $key != "." && $key != "-" && ($key < "0" || $key > "9") } {
    return
  }
  $self _any $key
}

defmethod Inputline _positive {key} {

  if { $key != "." && ($key < "0" || $key > "9") } {
    return
  }
  $self _any $key
}

defmethod Inputline _any {key} {

  set text [$self.entry get]
  if { $text == {} && $key == " " } {
    return
  }

  return $key
}

## proc Inputline(resize) {name size}
##	Change the width of the entry widget of an input line.
##
defmethod Inputline resize {size} {

  set size_entry [winfo reqwidth $self.entry]
  set size_max [expr $size-[winfo reqwidth $self.label]-5]
  if { [is $self.entry Text] } then {
    set size_max [expr $size_max-[winfo reqwidth $self.scroll]]
  }
  set size_chars [lindex [$self.entry! configure -width] 4]
  $self.entry! configure -width [expr $size_chars*$size_max/$size_entry]
  return $self
}
