#---------------------------------------------------------------------------
#
#	Scale Widgets
#
#---------------------------------------------------------------------------

defwidget Scale

defmethod Scale new {name args} {

  args	layout action {range {0 100}} {direction horizontal} label \
	{labelfont smallbold} {size 200} width getaction putaction value 

  if { [streq $width {}] } {
    set width [expr $size/10]
    if { $width > 30 } {
      set width 30
    }
  }

  if { [streq $value {}] } {
    set value [lindex $range 0]
  }

  set action [$self buildAction $action $name]
  set getaction [$self buildAction $getaction $name]
  set putaction [$self buildAction $putaction $name]

  scale $name \
	-relief flat -orient $direction \
	-label $label -font [Font slot $labelfont] \
	-command [list $name _set] \
	-state normal -showvalue false \
	-width $width -length $size \
	-from [lindex $range 0] -to [lindex $range 1] \
	-activeforeground [Color slot bg,active] \
	-foreground [Color slot fg] \
	-background [Color slot bg] \
	-sliderforeground [Color slot bg,button] \
	-sliderlength 20
	
  bind $name <Any-Enter> {}
  bind $name <Any-Leave> {}

  bind $name <Any-ButtonPress> {incr tk_priv(buttons)}
  bind $name <Any-ButtonRelease> {incr tk_priv(buttons) -1}

  Scale instantiate $name $layout

  $name slot label $label
  $name slot getaction $getaction
  $name slot putaction $putaction
  $name slot action $action

  $name set $value

  return $name
}

defmethod Scale get {} {

  set value [$self! get]

  set getaction [$self slot getaction]
  if { ![streq $getaction {}] } {
    set value [uplevel #0 [concat $getaction [list $value]]]
  }
  return $value
}

defmethod Scale _set {value} {

  set getaction [$self slot getaction]
  if { ![streq $getaction ""] } {
    set value [uplevel #0 [concat $getaction $value]]
  }

  set label [$self slot label]
  append label ": " $value
  $self! configure -label $label

  set action [$self slot action]
  if { ![streq $action {}] } {
    uplevel #0 [concat $action [list $value]]
  }
}

defmethod Scale set {value} {

  set putaction [$self slot putaction]
  if { ![streq $putaction {}] } {
    set ivalue [uplevel #0 [concat $putaction [list $value]]]
  } {
    set ivalue $value
  }
  set ivalue [format "%0.0f" $ivalue]

  $self _set $ivalue
  $self! set $ivalue

  return $value
}

defmethod Scale computeDemo {op n} {

  case $op {
  {get} {
	expr $n*$n
    }
  {put} {
	$self showAction $op $n
	expr sqrt($n*1.0)
    }
  }
}
